% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{capitals}
\alias{capitals}
\title{A complete list of capitals and capital transitions for Correlates of War state system members}
\format{
A data frame with 252 observations on the following 7 variables.
\describe{
\item{\code{ccode}}{a numeric vector for the Correlates of War state code}
\item{\code{statenme}}{a character vector for the state}
\item{\code{capital}}{a character vector for the name of the capital}
\item{\code{styear}}{a character vector for the start year. See details section for more information.}
\item{\code{endyear}}{a character vector for the end year. See details section for more information.}
\item{\code{lat}}{a numeric vector of the latitude coordinates for the capital}
\item{\code{lng}}{a numeric vector of the longitude coordinates for the capital}
}
}
\usage{
capitals
}
\description{
This is a complete list of capitals and capital transitions for Correlates of War state system members. I
use it internally for calculating capital-to-capital distances in the \code{add_capital_distances()} function.
}
\details{
For convenience, the start year for most states is 1816. Samoa, for example, was not a state
in 1816. However, the functions that use the \code{capitals} data will not create observations for states
that did not exist at a given point in time.

The data should be current as of the end of 2019.

Cases where a start year is not 1816 indicate a capital transition. For example, Brazil's capital moved from
Rio de Janeiro to Brasilia (a planned capital) in 1960. Only 25 states in the data experienced a capital transition.
The most recent was Burundi in 2018. Indonesia, as of writing, is planning on a capital transition, but this has not
been completed yet.

Kazakhstan renamed its capital for the state leader in 2019. These data retain the name of Astana.

The capitals data are not without some peculiarities. Prominently, Portugal transferred the Portuguese court from
Lisbon to Rio de Janeiro from 1808 to 1821. *This is recorded in the data.* A knowledge of the inter-state conflict data
will note there was no war or dispute between, say, Portugal and Spain (or Portugal and any other country) at any point
during this time, but it does create some weirdness that would suggest a massive distance between two countries, like
Portugal and Spain, that are otherwise land-contiguous.

On Spain: the republican government moved the capital at the start of the civil war (in 1936) to Valencia. However, it
abandoned this capital by 1937. I elect to not record this capital transition.

The data also do some (I think) reasonable back-dating of capitals to coincide with states in transition without
necessarily formal capitals by the first appearance in the state system membership data. These concern Lithuania,
Kazakhstan, and the Philippines. Kaunas is the initial post-independence capital of Lithuania. Almaty is the initial
post-independence capital of Kazakhstan. Quezon City is the initial post-independence capital of the Philippines.
This concerns, at the most, one or two years for each of these three countries.
}
\keyword{datasets}
