% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePed.R
\name{simulatePed}
\alias{simulatePed}
\title{Simulate pedigree, genetic merits and phenotypes}
\usage{
simulatePed(
  F0size,
  Va0,
  Ve,
  littersize = 1,
  ngen,
  mort.rate = 0,
  overlap.s = 0,
  overlap.d = 0,
  f.rate = 1,
  m.rate = 1,
  fsel = "R",
  msel = "R",
  f.order = "fsel",
  m.order = "msel"
)
}
\arguments{
\item{F0size}{: Even number of founder animals. No mortality, selection and non-random mating in this generation.}

\item{Va0}{: Additive genetic variance in the base generation (i.e., F0).}

\item{Ve}{: Residual variance, constant across generations.}

\item{littersize}{: Litter size, default = 1.}

\item{ngen}{: Number of generations to simulate after the founder generation.}

\item{mort.rate}{: Mortality rate per generation, after the availability of phenotype (e.g., birth weight, weaning weight)
and before the age of maturity (i.e., before mating), default = 0. Maximum \code{mort.rate} = 0.5.}

\item{overlap.s}{: Number of overlapping generations for sires, default = 0 for no generation overlap.}

\item{overlap.d}{: Number of overlapping generations for dams, default = 0 for no generation overlap.}

\item{f.rate}{: Proportion of females selected as dams, default = 1.}

\item{m.rate}{: Proportion of males (\code{<= f.rate}) selected as sires, default = 1.}

\item{fsel}{: If \code{"R"} (default), random selection on females;
if \code{"P"}, selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{msel}{: If \code{"R"} (default), random selection on males;
 if \code{"P"}, selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{f.order}{: Ordering selected females for mating;
if \code{"fsel"} (default), same as the selection order;
if \code{"R"} random ordering;
if \code{"P"}, ordering based on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, ordering based on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{m.order}{: Ordering selected males for mating;
if \code{"msel"} (default), same as the selection order;
if \code{"R"} random ordering;
if \code{"P"}, ordering based on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, ordering based on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}
}
\value{
ped : The output pedigree \code{data.frame}. Further information provided in \strong{Details}.
}
\description{
Simulate pedigree, genetic merits and phenotypes with random/assortative/disassortative matings
followed by random/non-random selection of males and females with similar/different selection patterns in males and females.
}
\details{
The output pedigree \code{data.frame} (\code{ped}) has 9 columns: ID, SIRE, DAM, SEX,
GEN (generation number starting with 0 for the base generation), PA (parent average),
MS (Mendelian Sampling), E (environment and residuals), and P (phenotype).

Random, assortative, and disassortative matings can be simulated with different combinations of
\code{fsel}, \code{msel}, \code{f.order}, and \code{m.order}.
}
\examples{
ped = simulatePed(
    F0size = 100,
    Va0 = 9,
    Ve = 36,
    littersize = 2,
    ngen = 4,
    mort.rate = 0.05,
    overlap.s = 1,
    overlap.d = 0,
    f.rate = 0.8,
    m.rate = 0.5,
    fsel = "P",
    msel = "PA",
    f.order = "fsel",
    m.order = "msel"
)

}
