% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoMarkerDistribution.R
\name{twoMarkerDistribution}
\alias{twoMarkerDistribution}
\title{Genotype distribution for two linked markers}
\usage{
twoMarkerDistribution(
  x,
  id,
  partialmarker1,
  partialmarker2,
  rho,
  loopBreakers = NULL,
  eliminate = 99,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{id}{A single ID label.}

\item{partialmarker1, partialmarker2}{Either a \code{marker} object, or the name (or
index) of a marker attached to \code{x}.}

\item{rho}{A single numeric in the interval \verb{[0, 0.5]}: the recombination
fraction between the two markers.}

\item{loopBreakers}{(Only relevant if the pedigree has loops). A vector with
ID labels of individuals to be used as loop breakers. If NULL (default)
loop breakers are selected automatically. See \code{\link[=breakLoops]{breakLoops()}}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal algorithm for reducing the genotype space. Positive values
can save time if \code{partialmarker1} and/or \code{partialmarker2} have many
alleles.}

\item{verbose}{A logical.}
}
\value{
A named matrix giving the joint genotype distribution.
}
\description{
Computes the joint genotype distribution of two markers for a specified
pedigree member, conditional on known genotypes and the recombination rate
between the markers.
}
\examples{

# A sib-pair pedigree
x = nuclearPed(children = c("bro1", "bro2"))

# Two SNP markers; first brother homozygous for the `1` allele
SNP1 = SNP2 = marker(x, bro1 = "1/1", afreq = c("1" = 0.5, "2" = 0.5))

plot(x, marker = list(SNP1, SNP2))

# Genotype distribution for the brother depends on linkage
twoMarkerDistribution(x, id = "bro2", SNP1, SNP2, rho = 0)
twoMarkerDistribution(x, id = "bro2", SNP1, SNP2, rho = 0.5)

# X-linked
chrom(SNP1) = chrom(SNP2) = "X"

plot(x, marker = list(SNP1, SNP2))

twoMarkerDistribution(x, id = "bro2", SNP1, SNP2, rho = 0)
twoMarkerDistribution(x, id = "bro2", SNP1, SNP2, rho = 0.5)

}
\seealso{
\code{\link[=oneMarkerDistribution]{oneMarkerDistribution()}}
}
\author{
Magnus Dehli Vigeland
}
