% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceAlleles.R
\name{lumpAlleles}
\alias{lumpAlleles}
\title{Allele lumping}
\usage{
lumpAlleles(x, markers = NULL, always = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{markers}{A vector of names or indices referring to markers attached to
\code{x}. (Default: All markers.)}

\item{always}{A logical. If TRUE, lumping is always attempted. By default
(FALSE) lumping is skipped for markers where all individuals are genotyped.}

\item{verbose}{A logical.}
}
\value{
An object similar to \code{x}, but whose attached markers have reduced
allele set.
}
\description{
Perform allele lumping (i.e., merging unobserved alleles) for all markers
attached to the input pedigree.
}
\examples{
x = nuclearPed() |> addMarker(geno = c("1/1", NA, NA), alleles = 1:4)

# Before lumping
afreq(x, 1)

# Lump
y = lumpAlleles(x, verbose = TRUE)
afreq(y, 1)

}
