% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_portfolio.R
\name{pq_portfolio}
\alias{pq_portfolio}
\title{calculating returns/equity of portfolio}
\usage{
pq_portfolio(dt, dtv, x, v = "volume", init_fund = NULL,
  method = "arithmetic", ...)
}
\arguments{
\item{dt}{a list/dataframe of price by asset.}

\item{dtv}{a dataframe of transaction volume by asset.}

\item{x}{the column name of adjusted asset price.}

\item{v}{the column name of asset volume, defaults to volume.}

\item{init_fund}{initial fund value.}

\item{method}{the method to calculate asset returns, the available values include arithmetic and log, defaults to arithmetic.}

\item{...}{ignored}
}
\description{
\code{pq_portfolio} calculates the weighted returns or the equity of a portfolio assets.
}
\examples{
library(pedquant)
library(data.table)

data(dt_banks)
datadj = md_stock_adjust(dt_banks, adjust = FALSE)

# example I 
dtv = data.table(
    symbol = c("601288.SS","601328.SS","601398.SS","601939.SS","601988.SS"), 
    volume = c(100, 200, 300, 300, 100)
)
dtRa = pq_portfolio(datadj, x='close_adj', dtv=dtv) 
pq_plot(dtRa, x = 'cumreturns')

dtRb = pq_return(dt_ssec, x = 'close', freq = 'daily', cumreturns = TRUE)
pq_plot(list(Ra = dtRa, Rb = dtRb$`000001.SS`), x = 'cumreturns', 
        multi_series = list(nrow=1, ncol=1))

# example II 
dtv = data.table(
    symbol = rep(c("601288.SS","601328.SS","601398.SS","601939.SS","601988.SS"), 3), 
    date = rep(c('2009-03-02', '2010-01-04', '2014-09-01'), each = 5), 
    volume = rep(c(100, 200, 300, 300, 100), 3) * rep(c(1, -1, 2), each = 5)
)
dtRa2 = pq_portfolio(datadj, x='close_adj', dtv=dtv, init_fund = 10000) 
pq_plot(dtRa2, x = 'balance', 
        addti = list(equity = list(), fund = list()))

}
