% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_modify.R
\name{ped_modify}
\alias{ped_modify}
\alias{addChildren}
\alias{addSon}
\alias{addDaughter}
\alias{addParents}
\alias{removeIndividuals}
\alias{branch}
\alias{subset.ped}
\title{Add/remove pedigree members}
\usage{
addChildren(
  x,
  father = NULL,
  mother = NULL,
  nch = NULL,
  sex = 1,
  ids = NULL,
  verbose = TRUE
)

addSon(x, parents, id = NULL, verbose = TRUE)

addDaughter(x, parents, id = NULL, verbose = TRUE)

addParents(x, id, father = NULL, mother = NULL, verbose = TRUE)

removeIndividuals(
  x,
  ids,
  remove = c("descendants", "ancestors"),
  returnLabs = FALSE,
  verbose = TRUE
)

branch(x, id)

\method{subset}{ped}(x, subset, ...)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{father, mother}{Single ID labels. At least one of these must belong to
an existing pedigree member. The other label may either: 1) belong to an
existing member, 2) not belong to any existing member, or 3) be missing
(i.e. not included in the function call). In cases 2 and 3 a new founder is
added to the pedigree. In case 2 its label is the one given, while in case
3 a suitable label is created by the program (see Details).}

\item{nch}{A positive integer indicating the number of children to be
created. Default: 1.}

\item{sex}{Gender codes of the created children (recycled if needed).}

\item{ids}{A character vector (or coercible to such) with ID labels. In
\code{addChildren} the (optional) \code{ids} argument is used to specify labels for
the created children. If given, its length must equal \code{nch}. If not given,
labels are assigned automatically as explained in Details.}

\item{verbose}{A logical: Verbose output or not.}

\item{parents}{A vector of 1 or 2 ID labels, of which at least one must be an
existing member of \code{x}.}

\item{id}{The ID label of a pedigree member.}

\item{remove}{Either "ancestors" or "descendants" (default), dictating the
method of removing pedigree members. Abbreviations are allowed.}

\item{returnLabs}{A logical, by default FALSE. If TRUE, \code{removeIndividuals()}
returns only the labels of all members to be removed, instead of actually
removing them.}

\item{subset}{A character vector (or coercible to such) with ID labels
forming a connected sub-pedigree.}

\item{...}{Not used.}
}
\value{
The modified \code{ped} object.
}
\description{
Functions for adding or removing individuals in a 'ped' object.
}
\details{
In \code{addChildren()} and \code{addParents()}, labels of added individuals are
created automatically if they are not specified by the user. In the automatic
case, the labelling depends on whether the existing labels are integer-like
or not (i.e. if \code{labels(x)} equals \code{as.character(as.integer(labels(x)))}.) If
so, the new labels are integers subsequent to the largest of the existing
labels. If not, the new labels are "NN_1", "NN_2", ... If any such label
already exists, the numbers are adjusted accordingly.

\code{addSon()} and \code{addDaughter()} are wrappers for the most common use of
\code{addChildren()}, namely adding a single child to a pedigree. Note that the
parents can be given in any order. If only one parent is supplied, the other
is created as a new individual.

\code{removeIndividuals()} removes the individuals indicated with \code{ids} along with
all of their ancestors OR descendants, depending on the \code{remove} argument.
Leftover spouses disconnected to the remaining pedigree are also removed. An
error is raised if result is a disconnected pedigree.

The \code{branch()} function extracts the sub-pedigree formed by \code{id} and all
his/her spouses and descendants.

Finally, \code{subset()} can be used to extract any connected sub-pedigree. (Note
that in the current implementation, the function does not actually check that
the indicated subset forms a connected pedigree; failing to comply with this
may lead to obscure errors.)
}
\examples{

x = nuclearPed(1) |>
  addSon(3) |>
  addParents(4, father = 6, mother = 7) |>
  addChildren(father = 6, mother = 7, nch = 3, sex = c(2,1,2))

# Remove 6 and 7 and their descendants
y1 = removeIndividuals(x, 6:7)

# Remove 8-10 and their parents
y2 = removeIndividuals(x, 8:10, remove = "ancestors")

}
\seealso{
\code{\link[=ped]{ped()}}, \code{\link[=relabel]{relabel()}}, \code{\link[=swapSex]{swapSex()}}
}
