% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{pbc2data}
\alias{pbc2data}
\title{pbc2 dataset}
\format{
The list contains two data frames:

\itemize{
\item \code{baselineInfo} contains the subject indicator `id`, information about
the survival outcome (`time` and `event`) and the covariates `baselineAge`, `sex`
and `treatment`;
\item \code{longitudinalInfo} contains the subject `id` and the repeated measurement 
data: `age` is the age of the individual at each visit, `fuptime` the follow-up time
(time on study), and `serBilir`, `serChol`, `albumin`, `alkaline`, `SGOT`,
`platelets` and `prothrombin` contain the value of each covariate at the 
corresponding visit
}
}
\usage{
data(pbc2data)
}
\description{
This list contains data from the Mayo Clinic primary biliary cirrhosis (PBC)
study (1974-1984). It comprises two datasets, one with the survival and baseline covariates
and the other with the longitudinal measurements. The datasets are a 
rearrangement of the `pbc2` dataframe from the `joineRML` package that makes
them more suitable for analysis within `pencal`
}
\examples{
data(pbc2data)
head(pbc2data$baselineInfo)
head(pbc2data$longitudinalInfo)
}
\author{
Mirko Signorelli
}
\keyword{datasets}
