% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{penhdfeppml}
\alias{penhdfeppml}
\title{One-Shot Penalized PPML Estimation with HDFE}
\usage{
penhdfeppml(
  data,
  dep = 1,
  indep = NULL,
  fixed = NULL,
  cluster = NULL,
  selectobs = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the name of the independent variable or a column number.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{fixed}{A vector with the names or column numbers of factor variables identifying the fixed effects,
or a list with the desired interactions between variables in \code{data}.}

\item{cluster}{Optional. A string with the name of the clustering variable or a column number.
It's also possible to input a vector with several variables, in which case the interaction of
all of them is taken as the clustering variable.}

\item{selectobs}{Optional. A vector indicating which observations to use (either a logical vector
or a numeric vector with row numbers, as usual when subsetting in R).}

\item{...}{Further options, including:
\itemize{
\item \code{penalty}: A string indicating the penalty type. Currently supported: "lasso" and "ridge".
\item \code{method}: The user can set this equal to "plugin" to perform the plugin algorithm with
coefficient-specific penalty weights (see details). Otherwise, a single global penalty is used.
}
For a full list of options, see \link{penhdfeppml_int}.}
}
\value{
If \code{method == "lasso"} (the default), an object of class \code{elnet} with the elements
described in \link[glmnet]{glmnet}, as well as:
\itemize{
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{phi}: coefficient-specific penalty weights (only if \code{method == "plugin"}.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
If \code{method == "ridge"}, a list with the following elements:
\itemize{
\item \code{beta}: a 1 x \code{ncol(x)} matrix with coefficient (beta) estimates.
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
}
\description{
\code{penhdfeppml} fits a penalized PPML regression for a given type of penalty and a given
value of the penalty parameter.  The penalty can be either lasso or ridge, and the plugin method
can be enabled via the \code{method} argument.
}
\details{
This function is a thin wrapper around \link{penhdfeppml_int}, providing a more convenient interface
for data frames. Whereas the internal function requires some preliminary handling of data sets (\code{y}
must be a vector, \code{x} must be a matrix and \code{fes} must be provided in a list), the wrapper
takes a full data frame in the \code{data} argument, and users can simply specify which variables
correspond to y, x and the fixed effects, using either variable names or column numbers.

More formally, \code{penhdfeppml_int} performs iteratively re-weighted least squares (IRLS) on a
transformed model, as described in Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2021).
In each iteration, the function calculates the transformed dependent variable, partials out the fixed
effects (calling \code{lfe::demeanlist}) and then and then calls \code{glmnet::glmnet} if the selected
penalty is lasso (the default). If the user has selected ridge, the analytical solution is instead
computed directly using fast C++ implementation.

For information on how the plugin lasso method works, see \link{penhdfeppml_cluster}.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
# To reduce run time, we keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
test <- penhdfeppml(data = trade[, -(5:6)],
                      dep = "export",
                      fixed = list(c("exp", "time"),
                                   c("imp", "time"),
                                   c("exp", "imp")),
                      lambda = 0.05,
                      selectobs = (trade$imp \%in\% americas) & (trade$exp \%in\% americas))

}
