% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructPPregion.R
\name{reconstructPPregion}
\alias{reconstructPPregion}
\title{Reconstruct perfect phylogeny sequencce across a region}
\usage{
reconstructPPregion(hapMat, minWindow, posn.lb = NULL, posn.ub = NULL)
}
\arguments{
\item{hapMat}{A data structure of class \code{hapMat}. See the arguments in \code{\link{reconstructPP}}.}

\item{minWindow}{Minimum number of SNVs around the focal SNV in the window of SNVs used to
reconstruct the perfect phylogeny.}

\item{posn.lb}{Lower bound of the subregion of \code{hapMat} (in base pairs) within which to consider SNVs.}

\item{posn.ub}{Upper bound of the subregion of \code{hapMat} (in base pairs) within which to consider SNVs.}
}
\value{
An object of class \code{multiPhylo} that contains multiple \code{phylo} objects.
}
\description{
This function reconstructs perfect phylogenies on each possible focal SNV across a genomic region.
}
\examples{

data(ex_hapMatSmall_data)   
                   
# Reconstruct partitions across the region of ex_hapMatSmall_data.
rdends <- reconstructPPregion(hapMat = ex_hapMatSmall_data,
                      minWindow = 1)
                      
# Reconstruct partitions between a given range SNV positions.
rdends_range <- reconstructPPregion(hapMat = ex_hapMatSmall_data, minWindow = 1,
                                      posn.lb = 2000, posn.ub = 7000)                      

}
