% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_residuals.R
\name{binned_residuals}
\alias{binned_residuals}
\title{Binned residuals for logistic regression}
\usage{
binned_residuals(model, term = NULL, n_bins = NULL, ...)
}
\arguments{
\item{model}{A \code{glm}-object with binomial-family.}

\item{term}{Name of independent variable from \code{x}. If not \code{NULL},
average residuals for the categories of \code{term} are plotted; else,
average residuals for the estimated probabilities of the response are
plotted.}

\item{n_bins}{Numeric, the number of bins to divide the data. If
\code{n_bins = NULL}, the square root of the number of observations is
taken.}

\item{...}{Further argument like \code{size} (for point-size) or
\code{color} (for point-colors).}
}
\value{
A data frame representing the data that is mapped to the plot, which is
  automatically plotted. In case all residuals are inside the error bounds,
  points are black. If some of the residuals are outside the error bounds
  (indicates by the grey-shaded area), blue points indicate residuals that
  are OK, while red points indicate model under- or overfitting for the
  related range of estimated probabilities.
}
\description{
Check model quality of logistic regression models.
}
\details{
Binned residual plots are achieved by \dQuote{dividing the data into
  categories (bins) based on their fitted values, and then plotting
  the average residual versus the average fitted value for each bin.}
  \cite{(Gelman, Hill 2007: 97)}. If the model were true, one would
  expect about 95\% of the residuals to fall inside the error bounds.
  \cr \cr
  If \code{term} is not \code{NULL}, one can compare the residuals in
  relation to a specific model predictor. This may be helpful to check
  if a term would fit better when transformed, e.g. a rising and falling
  pattern of residuals along the x-axis (the pattern is indicated by
  a green line) is a signal to consider taking the logarithm of the
  predictor (cf. Gelman and Hill 2007, pp. 97ff).
}
\note{
Since \code{binned_residuals()} returns a data frame, the default
  action for the result is \emph{printing}. However, the `print()`-method for
  \code{binned_residuals()} actually creates a plot. For further modifications
  of the plot, use `print()` and add ggplot-layers to the return values,
  e.g \code{plot(binned_residuals(model)) + see::scale_color_pizza()}.
}
\examples{
model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
binned_residuals(model)

}
\references{
Gelman, A., & Hill, J. (2007). Data analysis using regression and multilevel/hierarchical models. Cambridge; New York: Cambridge University Press.
}
