test_that("Permutations contain expected properties", {
  chacko66_sec3 <- c(10L, 16L, 14L, 12L, 18L)
  chacko66_sec5 <- c(12L, 14L, 18L, 16L, 22L, 20L, 18L, 24L, 26L, 30L)
  ruxton221207 <- c(6, 8, 4, 7, 3)
  set.seed(2393366)
  large_sample <- rpois(5L, lambda = 1e3L)
  for (i in seq_len(10)) {
    chacko66_sec3_perm <- permutateX(chacko66_sec3)
    chacko66_sec5_perm <- permutateX(chacko66_sec5)
    ruxton221207_perm <- permutateX(ruxton221207)
    large_sample_perm <- permutateX(large_sample)
    expect_equal(sum(chacko66_sec3_perm), sum(chacko66_sec3))
    expect_equal(sum(chacko66_sec5_perm), sum(chacko66_sec5))
    expect_equal(sum(ruxton221207_perm), sum(ruxton221207))
    expect_equal(length(chacko66_sec3_perm), length(chacko66_sec3))
    expect_equal(length(chacko66_sec5_perm), length(chacko66_sec5))
    expect_equal(length(ruxton221207_perm), length(ruxton221207))
    expect_lt(max(abs(large_sample_perm - large_sample)), 100L)
  }
})
