% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permLR.R
\name{nextStage}
\alias{nextStage}
\title{nextStage}
\usage{
nextStage(pgs.obj, alpha, formula, data = parent.frame())
}
\arguments{
\item{pgs.obj}{permGS object as returned by \code{\link{createPermGS}}}

\item{alpha}{alpha at current stage}

\item{formula}{a formula object, as used by \code{\link{coxph}}, left hand side must be a 'Surv' object, right hand side must only consist of a factor (treatment indicator) and optionally a special strata() term identifying the permutation strata}

\item{data}{a data.frame or list containing the variables in "formula", by default "formula" is evaluated in the parent frame}
}
\value{
An updated permGS object.
}
\description{
Imputation permutation group-sequential log-rank test.
Random permutations of a block a reused in all later stages. This automatically
results in blockwise permutations.
}
\examples{
## Two-stage design with one-sided O'Brien-Fleming boundaries using IPZ method
x <- createPermGS(1000, TRUE, "IPZ")

t1 <- 9  ## calendar time of interim analysis
t2 <- 18  ## calendar time of final analysis

T <- rexp(100) ## event times
R <- runif(100, 0, 12)  ## recruitment times
Z <- rbinom(100, 1, 0.5)  ## treatment assignment
C <- rexp(100) ## drop-out times

## Stage 1 data
data.t1 <- data.frame(time=pmin(T, C, max(0, (t1-R))), status=(T<=pmin(C, t1-R)), trt=Z)
data.t1 <- data.t1[R <= t1,]

## Stage 2 data
data.t2 <- data.frame(time=pmin(T, C, max(0, (t2-R))), status=(T<=pmin(C, t2-R)), trt=Z)
data.t2 <- data.t2[R <= t2,] 
x <- nextStage(x, 0.00153, Surv(time, status) ~ trt, data.t1)
summary(x)

if(!x$results$reject[1]) {
   data.t2$strata <- rep.int(c(1,2), c(nrow(data.t1), nrow(data.t2)-nrow(data.t1)))
   x <- nextStage(x, 0.025, Surv(time, status) ~ trt + strata(strata), data.t2)
   summary(x)
}
}

