% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permLR.R
\name{exactLR}
\alias{exactLR}
\title{exactLR}
\usage{
exactLR(B, formula, data = parent.frame(), type = "exact")
}
\arguments{
\item{B}{number of random permutations (only used if type="approximate")}

\item{formula}{a formula object, as used by \code{\link{coxph}}, left hand side must be a 'Surv' object, right hand side may only consist of a single term (treatment indicator)}

\item{data}{data.frame or list containing the variables in "formula", by default "formula" is evaluated in the parent frame}

\item{type}{if type="exact" performs complete enumeration of all permutations, if type="approximate" draw random permutations, if type="asymptotic" perform asymptotic log-rank test}
}
\value{
A list containing the exact or approximate permutation p-value and the observed test statistic
}
\description{
One-sided exact / approximate permutation and asymptotic log-rank test
}
\details{
This function performs a standard exact or approximate permutation test
which is only valid under the extended null hypothesis of equal survival
AND censoring distributions.
}
\examples{
T <- rexp(20)
C <- rexp(20)
data <- data.frame(time=pmin(T, C), status=(T<=C), trt=rbinom(20, 1, 0.5))

# Approximate permutation test using 1000 random permutations
x <- exactLR(1000, Surv(time, status) ~ trt, data, "approximate")

print(paste("Approximate permutation p-value:", x$p))

# Exact permutation test
y <- exactLR(0, Surv(time, status) ~ trt, data, "exact")
print(paste("Exact permutation p-value:", y$p))

}
