# This file defines dodecahedron_face, dodecahedron_edge,
# full_dodecahedron_face, and full_dodecahedron_edge.

# This file is not really intended to be human-readable.

# The source code for these statements is in
# inst/dodecahedron_group.py and inst/full_dodecahedron_group.py.  To
# create this file, execute dodecahedron_group.py in SAGE and
# cut-and-paste the output of 'dod_edge' (and the other objects).




dodecahedron_face <- as.cycle(c( "()", "(2,3,4,5,6)(7,11,10,9,8)",
"(1,2,3)(4,6,8)(5,9,7)(10,12,11)",
"(1,2)(3,6)(4,9)(5,8)(7,10)(11,12)",
"(1,3)(2,4)(5,8)(6,7)(9,11)(10,12)",
"(1,3,2)(4,8,6)(5,7,9)(10,11,12)", "(2,4,6,3,5)(7,10,8,11,9)",
"(1,4,3)(2,5,7)(6,11,8)(9,10,12)", "(1,3,8,9,6)(4,7,12,10,5)",
"(2,6,5,4,3)(7,8,9,10,11)", "(1,2,6)(3,9,5)(4,8,10)(7,12,11)",
"(2,5,3,6,4)(7,9,11,8,10)", "(1,4,7,8,2)(5,11,12,9,6)",
"(1,3,7,11,5)(2,8,12,10,6)", "(1,6,10,11,4)(2,9,12,7,3)",
"(1,2,9,10,5)(3,8,12,11,4)", "(1,6,9,8,3)(4,5,10,12,7)",
"(1,2,8,7,4)(5,6,9,12,11)", "(1,5,11,7,3)(2,6,10,12,8)",
"(1,5,10,9,2)(3,4,11,12,8)", "(1,4,11,10,6)(2,3,7,12,9)",
"(1,9,7)(2,8,3)(4,6,12)(5,10,11)", "(1,6,2)(3,5,9)(4,10,8)(7,11,12)",
"(1,5,6)(2,4,10)(3,11,9)(7,12,8)",
"(1,8)(2,3)(4,9)(5,12)(6,7)(10,11)", "(1,8,4,2,7)(5,9,11,6,12)",
"(1,9,3,6,8)(4,10,7,5,12)", "(1,4,5)(2,7,10)(3,11,6)(8,12,9)",
"(1,3,4)(2,7,5)(6,8,11)(9,12,10)", "(1,8,6,3,9)(4,12,5,7,10)",
"(1,5)(2,11)(3,10)(4,6)(7,9)(8,12)",
"(1,7,9)(2,3,8)(4,12,6)(5,11,10)",
"(1,6)(2,5)(3,10)(4,9)(7,12)(8,11)",
"(1,4)(2,11)(3,5)(6,7)(8,10)(9,12)",
"(1,9)(2,6)(3,10)(4,12)(5,8)(7,11)", "(1,7,2,4,8)(5,12,6,11,9)",
"(1,7)(2,11)(3,4)(5,8)(6,12)(9,10)", "(1,11,3,5,7)(2,10,8,6,12)",
"(1,6,5)(2,10,4)(3,9,11)(7,8,12)", "(1,5,4)(2,10,7)(3,6,11)(8,9,12)",
"(1,9,5,2,10)(3,12,4,8,11)", "(1,7,10)(2,8,9)(3,12,6)(4,11,5)",
"(1,11,8)(2,5,12)(3,4,7)(6,10,9)", "(1,8,10)(2,9,6)(3,12,5)(4,7,11)",
"(1,11,9)(2,4,12)(3,7,8)(5,10,6)", "(1,10,2,5,9)(3,11,8,4,12)",
"(1,8,11)(2,12,5)(3,7,4)(6,9,10)", "(1,10,4,6,11)(2,12,3,9,7)",
"(1,11,6,4,10)(2,7,9,3,12)", "(1,9,11)(2,12,4)(3,8,7)(5,6,10)",
"(1,10,7)(2,9,8)(3,6,12)(4,5,11)", "(1,10,8)(2,6,9)(3,5,12)(4,11,7)",
"(1,7,5,3,11)(2,12,6,8,10)", "(1,12)(2,11)(3,7)(4,8)(5,9)(6,10)",
"(1,11)(2,12)(3,10)(4,5)(6,7)(8,9)",
"(1,12)(2,8)(3,9)(4,10)(5,11)(6,7)",
"(1,12)(2,9)(3,10)(4,11)(5,7)(6,8)",
"(1,12)(2,7)(3,8)(4,9)(5,10)(6,11)",
"(1,10)(2,11)(3,12)(4,9)(5,6)(7,8)",
"(1,12)(2,10)(3,11)(4,7)(5,8)(6,9)"))

names(dodecahedron_face) <- NULL


dodecahedron_edge <- as.cycle(c( "()",
"(10,12,14,16,18)(20,32,44,56,24)(26,38,40,52,64)(28,30,42,54,66)(72,76,108,96,84)(74,112,100,98,86)",
"(10,24,38)(12,26,30)(14,28,32)(16,20,18)(40,56,84)(42,64,86)(44,66,72)(52,96,74)(54,98,76)(100,112,108)",
"(10,14,18,12,16)(20,44,24,32,56)(26,40,64,38,52)(28,42,66,30,54)(72,108,84,76,96)(74,100,86,112,98)",
"(10,26)(12,28)(14,20)(18,24)(30,64)(32,66)(38,56)(40,96)(42,98)(44,84)(52,86)(54,72)(74,108)(76,100)",
"(10,20)(12,38)(14,30)(16,32)(24,40)(26,42)(28,44)(52,84)(54,86)(56,72)(64,74)(66,76)(96,112)(98,108)",
"(10,38,24)(12,30,26)(14,32,28)(16,18,20)(40,84,56)(42,86,64)(44,72,66)(52,74,96)(54,76,98)(100,108,112)",
"(10,30,86,96,56)(12,32,72,98,64)(14,18,38,84,66)(16,20,28,26,24)(40,74,100,54,44)(42,76,112,108,52)",
"(10,28,64)(12,20,66)(14,16,24)(18,26,56)(30,98,52)(32,84,54)(38,96,44)(40,86,108)(42,72,100)(74,112,76)",
"(10,40,72,28,16)(12,42,74,84,24)(14,44,76,86,26)(18,32,30,38,20)(52,112,98,66,56)(54,108,100,96,64)",
"(10,32,18)(12,40,20)(14,42,38)(16,44,30)(24,52,72)(26,54,74)(28,56,76)(64,112,84)(66,108,86)(96,100,98)",
"(10,16,12,18,14)(20,56,32,24,44)(26,52,38,64,40)(28,54,30,66,42)(72,96,76,84,108)(74,98,112,86,100)",
"(10,18,16,14,12)(20,24,56,44,32)(26,64,52,40,38)(28,66,54,42,30)(72,84,96,108,76)(74,86,98,100,112)",
"(10,52,100,84,20)(12,54,96,26,16)(14,56,64,66,24)(18,44,108,98,28)(30,40,76,74,72)(32,42,112,86,38)",
"(10,56,96,86,30)(12,64,98,72,32)(14,66,84,38,18)(16,24,26,28,20)(40,44,54,100,74)(42,52,108,112,76)",
"(10,20,84,100,52)(12,16,26,96,54)(14,24,66,64,56)(18,28,98,108,44)(30,72,74,76,40)(32,38,86,112,42)",
"(10,16,28,72,40)(12,24,84,74,42)(14,26,86,76,44)(18,20,38,30,32)(52,56,66,98,112)(54,64,96,100,108)",
"(10,44,42,40,32)(12,52,76,30,18)(14,54,112,72,20)(16,56,108,74,38)(24,64,100,86,28)(26,66,96,98,84)",
"(10,42,108,64,14)(12,44,52,54,56)(16,32,76,100,66)(18,40,112,96,24)(20,30,74,98,26)(28,38,72,86,84)",
"(10,14,64,108,42)(12,56,54,52,44)(16,66,100,76,32)(18,24,96,112,40)(20,26,98,74,30)(28,84,86,72,38)",
"(10,32,40,42,44)(12,18,30,76,52)(14,20,72,112,54)(16,38,74,108,56)(24,28,86,100,64)(26,84,98,96,66)",
"(10,54,24)(12,56,14)(16,44,64)(18,52,66)(20,42,96)(26,32,108)(28,40,100)(30,112,84)(38,76,98)(72,74,86)",
"(10,18,32)(12,20,40)(14,38,42)(16,30,44)(24,72,52)(26,74,54)(28,76,56)(64,84,112)(66,86,108)(96,98,100)",
"(10,66,74)(12,96,76)(14,98,40)(16,84,30)(18,26,72)(20,28,38)(24,86,32)(42,56,100)(44,64,112)(52,54,108)",
"(10,84)(12,86)(14,72)(16,38)(18,28)(24,30)(26,32)(40,66)(42,96)(44,98)(52,100)(54,112)(56,74)(64,76)",
"(10,96,30,56,86)(12,98,32,64,72)(14,84,18,66,38)(16,26,20,24,28)(40,54,74,44,100)(42,108,76,52,112)",
"(10,44,12)(14,32,52)(16,40,54)(18,42,56)(20,76,64)(24,30,108)(26,72,100)(28,74,96)(38,112,66)(84,86,98)",
"(10,64,28)(12,66,20)(14,24,16)(18,56,26)(30,52,98)(32,54,84)(38,44,96)(40,108,86)(42,100,72)(74,76,112)",
"(10,28,40,16,72)(12,84,42,24,74)(14,86,44,26,76)(18,38,32,20,30)(52,66,112,56,98)(54,96,108,64,100)",
"(10,72,16,40,28)(12,74,24,42,84)(14,76,26,44,86)(18,30,20,32,38)(52,98,56,112,66)(54,100,64,108,96)",
"(10,30)(12,72)(14,74)(16,76)(18,40)(20,42)(24,112)(26,108)(28,52)(38,44)(54,84)(56,86)(64,98)(66,100)",
"(10,66)(12,24)(16,56)(18,64)(20,54)(26,44)(28,52)(30,100)(32,96)(38,108)(40,98)(42,84)(72,112)(76,86)",
"(10,74,66)(12,76,96)(14,40,98)(16,30,84)(18,72,26)(20,38,28)(24,32,86)(42,100,56)(44,112,64)(52,108,54)",
"(10,56)(14,44)(16,52)(18,54)(20,108)(24,42)(26,76)(28,112)(30,96)(32,64)(38,100)(40,66)(72,98)(74,84)",
"(10,98)(12,84)(14,26)(16,66)(18,96)(20,64)(28,56)(30,108)(32,100)(38,54)(40,112)(42,74)(44,86)(52,72)",
"(10,86,56,30,96)(12,72,64,32,98)(14,38,66,18,84)(16,28,24,20,26)(40,100,44,74,54)(42,112,52,76,108)",
"(12,32)(14,40)(16,42)(18,44)(20,52)(24,76)(26,112)(28,108)(30,56)(38,54)(64,72)(66,74)(84,100)(86,96)",
"(10,24,54)(12,14,56)(16,64,44)(18,66,52)(20,96,42)(26,108,32)(28,100,40)(30,84,112)(38,98,76)(72,86,74)",
"(10,112,26)(12,108,66)(14,52,96)(16,42,98)(18,76,84)(20,40,86)(24,44,100)(28,32,74)(30,72,38)(54,64,56)",
"(10,76,54)(12,40,108)(14,30,100)(16,72,96)(18,74,64)(20,86,66)(24,38,98)(26,28,84)(32,112,56)(42,52,44)",
"(10,12,44)(14,52,32)(16,54,40)(18,56,42)(20,64,76)(24,108,30)(26,100,72)(28,96,74)(38,66,112)(84,98,86)",
"(10,76,38)(12,112,28)(14,108,84)(16,52,86)(18,42,72)(20,44,74)(24,54,98)(26,56,100)(30,32,40)(64,96,66)",
"(10,72,108)(12,38,100)(14,28,96)(16,84,64)(18,86,54)(20,98,56)(24,26,66)(30,112,44)(32,74,52)(40,76,42)",
"(10,84,52,20,100)(12,26,54,16,96)(14,66,56,24,64)(18,98,44,28,108)(30,74,40,72,76)(32,86,42,38,112)",
"(10,42,32,44,40)(12,76,18,52,30)(14,112,20,54,72)(16,108,38,56,74)(24,100,28,64,86)(26,96,84,66,98)",
"(10,38,76)(12,28,112)(14,84,108)(16,86,52)(18,72,42)(20,74,44)(24,98,54)(26,100,56)(30,40,32)(64,66,96)",
"(10,108,72)(12,100,38)(14,96,28)(16,64,84)(18,54,86)(20,56,98)(24,66,26)(30,44,112)(32,52,74)(40,42,76)",
"(10,108,14,42,64)(12,52,56,44,54)(16,76,66,32,100)(18,112,24,40,96)(20,74,26,30,98)(28,72,84,38,86)",
"(10,54,76)(12,108,40)(14,100,30)(16,96,72)(18,64,74)(20,66,86)(24,98,38)(26,84,28)(32,56,112)(42,44,52)",
"(10,26,112)(12,66,108)(14,96,52)(16,98,42)(18,84,76)(20,86,40)(24,100,44)(28,74,32)(30,38,72)(54,56,64)",
"(10,100,20,52,84)(12,96,16,54,26)(14,64,24,56,66)(18,108,28,44,98)(30,76,72,40,74)(32,112,38,42,86)",
"(10,40,44,32,42)(12,30,52,18,76)(14,72,54,20,112)(16,74,56,38,108)(24,86,64,28,100)(26,98,66,84,96)",
"(10,64,42,14,108)(12,54,44,56,52)(16,100,32,66,76)(18,96,40,24,112)(20,98,30,26,74)(28,86,38,84,72)",
"(10,100)(12,112)(14,74)(16,86)(18,98)(20,84)(24,72)(26,38)(30,66)(32,96)(40,64)(42,54)(44,108)(56,76)",
"(10,96)(12,64)(14,54)(16,108)(18,100)(20,112)(24,52)(26,42)(28,76)(30,86)(32,98)(38,74)(40,84)(44,66)",
"(10,98)(12,100)(14,112)(16,74)(18,86)(20,72)(24,76)(26,40)(28,30)(32,84)(42,66)(44,96)(52,64)(56,108)",
"(10,52)(12,42)(14,76)(16,112)(18,108)(20,100)(24,74)(26,86)(28,98)(30,64)(32,54)(38,96)(40,56)(66,72)",
"(10,86)(12,98)(14,100)(16,112)(18,74)(20,76)(24,108)(26,52)(28,42)(32,72)(38,40)(44,84)(54,66)(56,96)",
"(10,112)(12,74)(14,86)(16,98)(18,100)(20,96)(24,84)(28,66)(30,54)(32,108)(38,64)(40,52)(44,76)(56,72)",
"(10,74)(12,86)(14,98)(16,100)(18,112)(20,108)(24,96)(26,64)(28,54)(30,42)(32,76)(38,52)(44,72)(56,84)"))

names(dodecahedron_edge) <- NULL


full_dodecahedron_face <- as.cycle(c(
"()",
"(2,3,4,5,6)(7,11,10,9,8)",
"(1,2,3)(4,6,8)(5,9,7)(10,12,11)",
"(3,6)(4,5)(7,10)(8,9)",
"(1,2)(3,6)(4,9)(5,8)(7,10)(11,12)",
"(1,2,6,9,10,12,11,7,4,3)(5,8)",
"(1,3)(2,4)(5,8)(6,7)(9,11)(10,12)",
"(2,6)(3,5)(7,11)(8,10)",
"(2,3)(4,6)(7,9)(10,11)",
"(1,2,3,8,7,12,11,10,5,6)(4,9)",
"(1,3,2)(4,8,6)(5,7,9)(10,11,12)",
"(2,4,6,3,5)(7,10,8,11,9)",
"(1,3,2,8,9,12,10,11,5,4)(6,7)",
"(2,5,3,6,4)(7,9,11,8,10)",
"(1,3,4,7,11,12,10,9,6,2)(5,8)",
"(1,3,7,12,10,6)(2,4,8,11,9,5)",
"(2,5)(3,4)(8,11)(9,10)",
"(1,2)(4,8)(5,9)(11,12)",
"(1,3,8,9,6)(4,7,12,10,5)",
"(1,3)(5,7)(6,8)(10,12)",
"(1,4,3)(2,5,7)(6,11,8)(9,10,12)",
"(1,6,10,12,7,3)(2,5,9,11,8,4)",
"(2,6,5,4,3)(7,8,9,10,11)",
"(1,4,7,8,2)(5,11,12,9,6)",
"(1,2,8,12,11,5)(3,9,7,10,4,6)",
"(1,2,6)(3,9,5)(4,8,10)(7,12,11)",
"(2,4)(5,6)(7,8)(9,11)",
"(1,6,5,10,11,12,7,8,3,2)(4,9)",
"(1,4,11,10,6)(2,3,7,12,9)",
"(1,6,9,8,3)(4,5,10,12,7)",
"(1,2,8,7,4)(5,6,9,12,11)",
"(1,6,2)(3,5,9)(4,10,8)(7,11,12)",
"(1,6)(3,9)(4,10)(7,12)",
"(1,6,10,11,4)(2,9,12,7,3)",
"(1,2,9,10,5)(3,8,12,11,4)",
"(1,4,5,11,10,12,9,8,2,3)(6,7)",
"(1,2,9,12,11,4)(3,6,8,10,7,5)",
"(1,5,11,7,3)(2,6,10,12,8)",
"(1,4,7,12,9,6)(2,5,3,11,8,10)",
"(1,4,11,12,9,2)(3,5,7,10,8,6)",
"(1,3,7,11,5)(2,8,12,10,6)",
"(1,5,10,12,8,3)(2,4,6,11,9,7)",
"(1,5,11,12,8,2)(3,6,4,10,7,9)",
"(1,4)(2,7)(6,11)(9,12)",
"(1,8)(4,7)(5,12)(6,9)",
"(1,5,10,9,2)(3,4,11,12,8)",
"(1,6)(2,5)(3,10)(4,9)(7,12)(8,11)",
"(1,8,6,12,5,7)(2,9,10,11,4,3)",
"(1,3,8,12,10,5)(2,7,9,11,6,4)",
"(1,8,6,3,9)(4,12,5,7,10)",
"(1,8,4,2,7)(5,9,11,6,12)",
"(1,4,3,7,8,12,9,10,6,5)(2,11)",
"(1,6,5)(2,10,4)(3,9,11)(7,8,12)",
"(1,8,4,12,5,9)(2,3,7,11,10,6)",
"(1,8,10)(2,9,6)(3,12,5)(4,7,11)",
"(1,8)(2,3)(4,9)(5,12)(6,7)(10,11)",
"(1,5,6)(2,4,10)(3,11,9)(7,12,8)",
"(1,5,4,11,7,12,8,9,2,6)(3,10)",
"(1,4,5)(2,7,10)(3,11,6)(8,12,9)",
"(1,5,4)(2,10,7)(3,6,11)(8,9,12)",
"(1,9,5,12,4,8)(2,6,10,11,7,3)",
"(1,7,5,12,6,8)(2,3,4,11,10,9)",
"(1,9,7)(2,8,3)(4,6,12)(5,10,11)",
"(1,6,2,9,8,12,7,11,4,5)(3,10)",
"(1,9,3,6,8)(4,10,7,5,12)",
"(1,3,4)(2,7,5)(6,8,11)(9,12,10)",
"(1,5,6,10,9,12,8,7,3,4)(2,11)",
"(1,9)(3,8)(4,12)(5,10)",
"(1,7)(2,8)(5,11)(6,12)",
"(1,5)(2,11)(3,10)(4,6)(7,9)(8,12)",
"(1,9,3,12,4,10)(2,8,7,11,5,6)",
"(1,7,10,2,4,12,6,3,11,9)(5,8)",
"(1,10,7)(2,9,8)(3,6,12)(4,5,11)",
"(1,7,9)(2,3,8)(4,12,6)(5,11,10)",
"(1,5)(2,10)(3,11)(8,12)",
"(1,9,11)(2,12,4)(3,8,7)(5,6,10)",
"(1,11,9,3,5,12,2,4,10,8)(6,7)",
"(1,8,11,6,3,12,5,2,7,10)(4,9)",
"(1,10,8)(2,6,9)(3,5,12)(4,11,7)",
"(1,6,9,12,7,4)(2,10,8,11,3,5)",
"(1,11,6,12,2,7)(3,4,5,10,9,8)",
"(1,8,11)(2,12,5)(3,7,4)(6,9,10)",
"(1,4)(2,11)(3,5)(6,7)(8,10)(9,12)",
"(1,9)(2,6)(3,10)(4,12)(5,8)(7,11)",
"(1,9,11,3,6,12,4,2,10,7)(5,8)",
"(1,7,10)(2,8,9)(3,12,6)(4,11,5)",
"(1,7)(2,11)(3,4)(5,8)(6,12)(9,10)",
"(1,7,2,4,8)(5,12,6,11,9)",
"(1,10,7,2,5,12,3,6,11,8)(4,9)",
"(1,7,9,5,3,12,6,4,8,10)(2,11)",
"(1,7,2,12,6,11)(3,8,9,10,5,4)",
"(1,11,6,4,10)(2,7,9,3,12)",
"(1,11,8)(2,5,12)(3,4,7)(6,10,9)",
"(1,9,7,5,2,12,4,6,8,11)(3,10)",
"(1,11,9)(2,4,12)(3,7,8)(5,10,6)",
"(1,10)(2,9)(3,12)(4,11)",
"(1,9,5,2,10)(3,12,4,8,11)",
"(1,12)(2,8)(3,9)(4,10)(5,11)(6,7)",
"(1,10,2,5,9)(3,11,8,4,12)",
"(1,12)(2,7)(3,8)(4,9)(5,10)(6,11)",
"(1,11,3,5,7)(2,10,8,6,12)",
"(1,11,8,6,4,12,2,5,7,9)(3,10)",
"(1,7,5,3,11)(2,12,6,8,10)",
"(1,10,4,12,3,9)(2,6,5,11,7,8)",
"(1,10,8,4,6,12,3,5,9,7)(2,11)",
"(1,8,10,4,2,12,5,3,9,11)(6,7)",
"(1,11)(2,12)(3,7)(6,10)",
"(1,11,3,12,2,10)(4,7,8,9,6,5)",
"(1,10,2,12,3,11)(4,5,6,9,8,7)",
"(1,12)(2,9)(3,10)(4,11)(5,7)(6,8)",
"(1,10,4,6,11)(2,12,3,9,7)",
"(1,11)(2,12)(3,10)(4,5)(6,7)(8,9)",
"(1,12)(2,10,4,8,6,11,3,9,5,7)",
"(1,12)(2,9,6,10,5,11,4,7,3,8)",
"(1,12)(2,8,3,7,4,11,5,10,6,9)",
"(1,12)(2,7,5,9,3,11,6,8,4,10)",
"(1,12)(2,11)(3,7)(4,8)(5,9)(6,10)",
"(1,10)(2,11)(3,12)(4,9)(5,6)(7,8)",
"(1,12)(2,10)(3,11)(4,7)(5,8)(6,9)",
"(1,12)(2,11)(3,10)(4,9)(5,8)(6,7)"))

names(full_dodecahedron_face) <- NULL



full_dodecahedron_edge <- as.cycle(c(
"()",
"(10,12)(14,18)(20,24)(26,28)(30,64)(32,56)(38,66)(40,54)(42,52)(72,96)(74,100)(76,108)(86,98)",
"(10,12,14,16,18)(20,32,44,56,24)(26,38,40,52,64)(28,30,42,54,66)(72,76,108,96,84)(74,112,100,98,86)",
"(10,24,38)(12,26,30)(14,28,32)(16,20,18)(40,56,84)(42,64,86)(44,66,72)(52,96,74)(54,98,76)(100,112,108)",
"(10,14,18,12,16)(20,44,24,32,56)(26,40,64,38,52)(28,42,66,30,54)(72,108,84,76,96)(74,100,86,112,98)",
"(10,26)(12,28)(14,20)(18,24)(30,64)(32,66)(38,56)(40,96)(42,98)(44,84)(52,86)(54,72)(74,108)(76,100)",
"(12,18)(14,16)(20,56)(26,66)(28,64)(30,52)(32,44)(38,54)(40,42)(72,108)(74,112)(84,96)(86,100)",
"(10,38,24)(12,30,26)(14,32,28)(16,18,20)(40,84,56)(42,86,64)(44,72,66)(52,74,96)(54,76,98)(100,108,112)",
"(10,14)(16,18)(24,32)(26,30)(28,38)(40,66)(42,64)(44,56)(52,54)(72,84)(74,98)(76,96)(100,112)",
"(10,20)(12,38)(14,30)(16,32)(24,40)(26,42)(28,44)(52,84)(54,86)(56,72)(64,74)(66,76)(96,112)(98,108)",
"(10,26,32,84,40,98,42,96,44,66)(12,24,18,28,30,86,76,100,52,64)(14,16,20,38,72,74,112,108,54,56)",
"(10,20,14,26,64,98,108,74,42,30)(12,28,56,84,54,86,52,72,44,38)(16,24,66,96,100,112,76,40,32,18)",
"(10,28,64)(12,20,66)(14,16,24)(18,26,56)(30,98,52)(32,84,54)(38,96,44)(40,86,108)(42,72,100)(74,112,76)",
"(10,16,12,18,14)(20,56,32,24,44)(26,52,38,64,40)(28,54,30,66,42)(72,96,76,84,108)(74,98,112,86,100)",
"(10,24,38,98,76,54)(12,16,28,86,112,52)(14,20,84,74,108,44)(18,26,72,100,42,56)(30,96,40,64,32,66)",
"(10,40,72,28,16)(12,42,74,84,24)(14,44,76,86,26)(18,32,30,38,20)(52,112,98,66,56)(54,108,100,96,64)",
"(10,30,42,74,108,98,64,26,14,20)(12,38,44,72,52,86,54,84,56,28)(16,18,32,40,76,112,100,96,66,24)",
"(10,18,20,28,84,98,100,108,52,44)(12,32,16,38,26,86,96,112,54,42)(14,30,24,72,66,74,64,76,56,40)",
"(10,28)(12,26)(14,24)(18,20)(32,38)(40,72)(42,86)(44,84)(52,98)(54,96)(56,66)(74,76)(100,108)",
"(10,66,44,96,42,98,40,84,32,26)(12,64,52,100,76,86,30,28,18,24)(14,56,54,108,112,74,72,38,20,16)",
"(10,30,86,96,56)(12,32,72,98,64)(14,18,38,84,66)(16,20,28,26,24)(40,74,100,54,44)(42,76,112,108,52)",
"(10,18)(12,16)(20,44)(24,56)(26,54)(28,52)(30,40)(38,42)(64,66)(72,76)(84,108)(86,112)(98,100)",
"(10,16)(12,14)(20,32)(24,44)(26,42)(28,40)(30,38)(52,66)(54,64)(74,86)(76,84)(96,108)(98,112)",
"(10,18,16,14,12)(20,24,56,44,32)(26,64,52,40,38)(28,66,54,42,30)(72,84,96,108,76)(74,86,98,100,112)",
"(10,32,18)(12,40,20)(14,42,38)(16,44,30)(24,52,72)(26,54,74)(28,56,76)(64,112,84)(66,108,86)(96,100,98)",
"(10,24,54,98,76,38)(12,66,108,86,40,20)(14,64,100,74,30,18)(16,56,96,112,72,32)(26,52,84,42,28,44)",
"(10,32)(12,30)(14,38)(16,20)(24,28)(40,44)(52,76)(54,74)(56,72)(64,86)(66,84)(96,98)(108,112)",
"(10,38,76,98,54,24)(12,20,40,86,108,66)(14,18,30,74,100,64)(16,32,72,112,96,56)(26,44,28,42,84,52)",
"(10,54,76,98,38,24)(12,52,112,86,28,16)(14,44,108,74,84,20)(18,56,42,100,72,26)(30,66,32,64,40,96)",
"(10,52,100,84,20)(12,54,96,26,16)(14,56,64,66,24)(18,44,108,98,28)(30,40,76,74,72)(32,42,112,86,38)",
"(10,72)(12,86)(14,84)(16,28)(18,38)(24,26)(30,32)(42,76)(44,74)(52,112)(54,100)(56,98)(64,96)",
"(10,42,112,98,26,16)(12,40,108,86,66,20)(14,32,52,74,96,28)(18,44,76,100,84,24)(30,54,72,64,38,56)",
"(10,38,24,98,54,76)(12,72,14,86,56,74)(16,84,64,112,44,30)(18,28,66,100,52,40)(20,26,96,108,42,32)",
"(10,16,28,72,40)(12,24,84,74,42)(14,26,86,76,44)(18,20,38,30,32)(52,56,66,98,112)(54,64,96,100,108)",
"(10,64)(12,56)(16,24)(18,66)(20,26)(30,98)(32,96)(38,84)(40,100)(42,108)(44,54)(72,86)(76,112)",
"(10,16,26,98,112,42)(12,20,66,86,108,40)(14,28,96,74,52,32)(18,24,84,100,76,44)(30,56,38,64,72,54)",
"(10,42,108,64,14)(12,44,52,54,56)(16,32,76,100,66)(18,40,112,96,24)(20,30,74,98,26)(28,38,72,86,84)",
"(10,56,108,98,72,20)(12,54,100,86,38,18)(14,52,96,74,28,32)(16,44,64,112,84,30)(24,42,66,76,26,40)",
"(10,40,74,98,66,14)(12,32,76,86,96,24)(16,44,30,112,84,64)(18,42,72,100,26,56)(20,52,38,108,28,54)",
"(10,20,84,100,52)(12,16,26,96,54)(14,24,66,64,56)(18,28,98,108,44)(30,72,74,76,40)(32,38,86,112,42)",
"(10,64,28)(12,66,20)(14,24,16)(18,56,26)(30,52,98)(32,54,84)(38,44,96)(40,108,86)(42,100,72)(74,76,112)",
"(12,44)(14,42)(16,40)(18,32)(20,30)(24,76)(26,74)(28,72)(52,56)(64,108)(66,112)(84,86)(96,100)",
"(10,44,52,108,100,98,84,28,20,18)(12,42,54,112,96,86,26,38,16,32)(14,40,56,76,64,74,66,72,24,30)",
"(10,44,42,40,32)(12,52,76,30,18)(14,54,112,72,20)(16,56,108,74,38)(24,64,100,86,28)(26,66,96,98,84)",
"(10,32,40,42,44)(12,18,30,76,52)(14,20,72,112,54)(16,38,74,108,56)(24,28,86,100,64)(26,84,98,96,66)",
"(10,56,96,86,30)(12,64,98,72,32)(14,66,84,38,18)(16,24,26,28,20)(40,44,54,100,74)(42,52,108,112,76)",
"(10,66)(12,24)(16,56)(18,64)(20,54)(26,44)(28,52)(30,100)(32,96)(38,108)(40,98)(42,84)(72,112)(76,86)",
"(10,14,64,108,42)(12,56,54,52,44)(16,66,100,76,32)(18,24,96,112,40)(20,26,98,74,30)(28,84,86,72,38)",
"(10,20,72,98,108,56)(12,18,38,86,100,54)(14,32,28,74,96,52)(16,30,84,112,64,44)(24,40,26,76,66,42)",
"(10,98)(12,96)(14,66)(16,26)(18,84)(20,28)(30,72)(32,86)(40,74)(42,112)(44,100)(52,108)(56,64)",
"(10,40)(12,76)(14,74)(16,72)(18,30)(20,38)(24,86)(26,84)(42,44)(54,108)(56,112)(64,100)(66,98)",
"(10,24,54)(12,14,56)(16,64,44)(18,66,52)(20,96,42)(26,108,32)(28,100,40)(30,84,112)(38,98,76)(72,86,74)",
"(10,84,12,98,44,86)(14,96,52,74,32,28)(16,66,54,112,40,38)(18,26,56,100,42,72)(20,24,64,108,76,30)",
"(10,28,40,16,72)(12,84,42,24,74)(14,86,44,26,76)(18,38,32,20,30)(52,66,112,56,98)(54,96,108,64,100)",
"(10,66,74)(12,96,76)(14,98,40)(16,84,30)(18,26,72)(20,28,38)(24,86,32)(42,56,100)(44,64,112)(52,54,108)",
"(10,72,108)(12,38,100)(14,28,96)(16,84,64)(18,86,54)(20,98,56)(24,26,66)(30,112,44)(32,74,52)(40,76,42)",
"(10,86,44,98,12,84)(14,28,32,74,52,96)(16,38,40,112,54,66)(18,72,42,100,56,26)(20,30,76,108,64,24)",
"(10,54,24)(12,56,14)(16,44,64)(18,52,66)(20,42,96)(26,32,108)(28,40,100)(30,112,84)(38,76,98)(72,74,86)",
"(10,18,32)(12,20,40)(14,38,42)(16,30,44)(24,72,52)(26,74,54)(28,76,56)(64,84,112)(66,86,108)(96,98,100)",
"(10,76,54,98,24,38)(12,74,56,86,14,72)(16,30,44,112,64,84)(18,40,52,100,66,28)(20,32,42,108,96,26)",
"(10,84)(12,86)(14,72)(16,38)(18,28)(24,30)(26,32)(40,66)(42,96)(44,98)(52,100)(54,112)(56,74)(64,76)",
"(10,12,56,64,96,98,86,72,30,32)(14,54,66,100,84,74,38,40,18,44)(16,52,24,108,26,112,28,76,20,42)",
"(10,44,12)(14,32,52)(16,40,54)(18,42,56)(20,76,64)(24,30,108)(26,72,100)(28,74,96)(38,112,66)(84,86,98)",
"(10,52,40,112,72,98,28,66,16,56)(12,44,42,76,74,86,84,26,24,14)(18,54,32,108,30,100,38,96,20,64)",
"(10,96,30,56,86)(12,98,32,64,72)(14,84,18,66,38)(16,26,20,24,28)(40,54,74,44,100)(42,108,76,52,112)",
"(10,32,30,72,86,98,96,64,56,12)(14,44,18,40,38,74,84,100,66,54)(16,42,20,76,28,112,26,108,24,52)",
"(10,56,16,66,28,98,72,112,40,52)(12,14,24,26,84,86,74,76,42,44)(18,64,20,96,38,100,30,108,32,54)",
"(10,12,44)(14,52,32)(16,54,40)(18,56,42)(20,64,76)(24,108,30)(26,100,72)(28,96,74)(38,66,112)(84,98,86)",
"(10,86,56,30,96)(12,72,64,32,98)(14,38,66,18,84)(16,28,24,20,26)(40,100,44,74,54)(42,112,52,76,108)",
"(10,54,76)(12,108,40)(14,100,30)(16,96,72)(18,64,74)(20,66,86)(24,98,38)(26,84,28)(32,56,112)(42,44,52)",
"(10,38,76)(12,28,112)(14,84,108)(16,86,52)(18,72,42)(20,74,44)(24,98,54)(26,100,56)(30,40,32)(64,66,96)",
"(10,108,72)(12,100,38)(14,96,28)(16,64,84)(18,54,86)(20,56,98)(24,66,26)(30,44,112)(32,52,74)(40,42,76)",
"(10,26,112)(12,66,108)(14,96,52)(16,98,42)(18,84,76)(20,86,40)(24,100,44)(28,74,32)(30,38,72)(54,56,64)",
"(10,14,66,98,74,40)(12,24,96,86,76,32)(16,64,84,112,30,44)(18,56,26,100,72,42)(20,54,28,108,38,52)",
"(10,76,54)(12,40,108)(14,30,100)(16,72,96)(18,74,64)(20,86,66)(24,38,98)(26,28,84)(32,112,56)(42,52,44)",
"(10,26,108,30,14,98,42,20,64,74)(12,84,52,38,56,86,44,28,54,72)(16,96,76,18,66,112,32,24,100,40)",
"(10,44)(14,56)(16,54)(18,52)(20,108)(24,64)(26,96)(28,100)(30,76)(32,42)(38,112)(72,74)(84,98)",
"(10,56)(14,44)(16,52)(18,54)(20,108)(24,42)(26,76)(28,112)(30,96)(32,64)(38,100)(40,66)(72,98)(74,84)",
"(10,74,66)(12,76,96)(14,40,98)(16,30,84)(18,72,26)(20,38,28)(24,32,86)(42,100,56)(44,112,64)(52,108,54)",
"(10,84,42,66,32,98,44,26,40,96)(12,28,76,64,18,86,52,24,30,100)(14,38,112,56,20,74,54,16,72,108)",
"(10,72,16,40,28)(12,74,24,42,84)(14,76,26,44,86)(18,30,20,32,38)(52,98,56,112,66)(54,100,64,108,96)",
"(10,30)(12,72)(14,74)(16,76)(18,40)(20,42)(24,112)(26,108)(28,52)(38,44)(54,84)(56,86)(64,98)(66,100)",
"(10,108,84,18,52,98,20,44,100,28)(12,112,26,32,54,86,16,42,96,38)(14,76,66,30,56,74,24,40,64,72)",
"(10,98)(12,84)(14,26)(16,66)(18,96)(20,64)(28,56)(30,108)(32,100)(38,54)(40,112)(42,74)(44,86)(52,72)",
"(10,52,64,98,28,30)(12,108,66,86,20,40)(14,112,24,74,16,76)(18,42,56,100,26,72)(32,44,54,96,84,38)",
"(10,96,18,98,32,100)(12,66,20,86,40,108)(14,26,38,74,42,54)(16,84,30,112,44,64)(24,28,72,76,52,56)",
"(10,74,64,20,42,98,14,30,108,26)(12,72,54,28,44,86,56,38,52,84)(16,40,100,24,32,112,66,18,76,96)",
"(12,32)(14,40)(16,42)(18,44)(20,52)(24,76)(26,112)(28,108)(30,56)(38,54)(64,72)(66,74)(84,100)(86,96)",
"(10,66,72,52,16,98,40,56,28,112)(12,26,74,44,24,86,42,14,84,76)(18,96,30,54,20,100,32,64,38,108)",
"(10,100)(12,112)(14,74)(16,86)(18,98)(20,84)(24,72)(26,38)(30,66)(32,96)(40,64)(42,54)(44,108)(56,76)",
"(10,96,40,26,44,98,32,66,42,84)(12,100,30,24,52,86,18,64,76,28)(14,108,72,16,54,74,20,56,112,38)",
"(10,64,86,32,56,98,30,12,96,72)(14,100,38,44,66,74,18,54,84,40)(16,108,28,42,24,112,20,52,26,76)",
"(10,42,32,44,40)(12,76,18,52,30)(14,112,20,54,72)(16,108,38,56,74)(24,100,28,64,86)(26,96,84,66,98)",
"(10,100,20,52,84)(12,96,16,54,26)(14,64,24,56,66)(18,108,28,44,98)(30,76,72,40,74)(32,112,38,42,86)",
"(10,112,26)(12,108,66)(14,52,96)(16,42,98)(18,76,84)(20,40,86)(24,44,100)(28,32,74)(30,72,38)(54,64,56)",
"(10,28,100,44,20,98,52,18,84,108)(12,38,96,42,16,86,54,32,26,112)(14,72,64,40,24,74,56,30,66,76)",
"(10,112,28,56,40,98,16,52,72,66)(12,76,84,14,42,86,24,44,74,26)(18,108,38,64,32,100,20,54,30,96)",
"(10,72,96,12,30,98,56,32,86,64)(14,40,84,54,18,74,66,44,38,100)(16,76,26,52,20,112,24,42,28,108)",
"(10,108,14,42,64)(12,52,56,44,54)(16,76,66,32,100)(18,112,24,40,96)(20,74,26,30,98)(28,72,84,38,86)",
"(10,98)(12,100)(14,112)(16,74)(18,86)(20,72)(24,76)(26,40)(28,30)(32,84)(42,66)(44,96)(52,64)(56,108)",
"(10,108)(12,54)(14,64)(16,96)(18,100)(20,98)(24,66)(28,84)(30,74)(32,112)(38,86)(40,76)(44,52)",
"(10,100,32,98,18,96)(12,108,40,86,20,66)(14,54,42,74,38,26)(16,64,44,112,30,84)(24,56,52,76,72,28)",
"(10,40,44,32,42)(12,30,52,18,76)(14,72,54,20,112)(16,74,56,38,108)(24,86,64,28,100)(26,98,66,84,96)",
"(10,84,52,20,100)(12,26,54,16,96)(14,66,56,24,64)(18,98,44,28,108)(30,74,40,72,76)(32,86,42,38,112)",
"(10,30,28,98,64,52)(12,40,20,86,66,108)(14,76,16,74,24,112)(18,72,26,100,56,42)(32,38,84,96,54,44)",
"(10,76,38)(12,112,28)(14,108,84)(16,52,86)(18,42,72)(20,44,74)(24,54,98)(26,56,100)(30,32,40)(64,96,66)",
"(10,74,18,86,16,98,14,100,12,112)(20,84,24,96,56,108,44,76,32,72)(26,66,64,54,52,42,40,30,38,28)",
"(10,96)(12,64)(14,54)(16,108)(18,100)(20,112)(24,52)(26,42)(28,76)(30,86)(32,98)(38,74)(40,84)(44,66)",
"(10,86,14,112,18,98,12,74,16,100)(20,96,44,72,24,108,32,84,56,76)(26,54,40,28,64,42,38,66,52,30)",
"(10,100,16,74,12,98,18,112,14,86)(20,76,56,84,32,108,24,72,44,96)(26,30,52,66,38,42,64,28,40,54)",
"(10,64,42,14,108)(12,54,44,56,52)(16,100,32,66,76)(18,96,40,24,112)(20,98,30,26,74)(28,86,38,84,72)",
"(10,76,38,98,24,54)(12,42,30,86,26,64)(14,52,32,74,28,96)(16,108,18,112,20,100)(40,72,84,66,56,44)",
"(10,112,12,100,14,98,16,86,18,74)(20,72,32,76,44,108,56,96,24,84)(26,28,38,30,40,42,52,54,64,66)",
"(10,86)(12,98)(14,100)(16,112)(18,74)(20,76)(24,108)(26,52)(28,42)(32,72)(38,40)(44,84)(54,66)(56,96)",
"(10,42)(12,52)(14,108)(16,112)(18,76)(20,74)(24,100)(26,98)(28,86)(32,40)(38,72)(54,56)(66,96)",
"(10,112)(12,74)(14,86)(16,98)(18,100)(20,96)(24,84)(28,66)(30,54)(32,108)(38,64)(40,52)(44,76)(56,72)",
"(10,54,24,98,38,76)(12,64,26,86,30,42)(14,96,28,74,32,52)(16,100,20,112,18,108)(40,44,56,66,84,72)",
"(10,52)(12,42)(14,76)(16,112)(18,108)(20,100)(24,74)(26,86)(28,98)(30,64)(32,54)(38,96)(40,56)(66,72)",
"(10,74)(12,86)(14,98)(16,100)(18,112)(20,108)(24,96)(26,64)(28,54)(30,42)(32,76)(38,52)(44,72)(56,84)",
"(10,98)(12,86)(14,74)(16,112)(18,100)(20,108)(24,76)(26,42)(28,52)(30,64)(32,96)(38,54)(40,66)(44,84)(56,72)"))

names(full_dodecahedron_edge) <- NULL
