% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discoverability.R
\name{perm.lm}
\alias{perm.lm}
\title{A general permutation test for mixed-effects models or other \code{buildmer} models. This is an alias for \code{perm.lmer}, except that random effects are explicily disallowed.}
\usage{
perm.lm(
  formula,
  data = NULL,
  family = gaussian(),
  weights = NULL,
  offset = NULL,
  buildmerControl = list(direction = "order", crit = "LRT", quiet = TRUE, ddf = "lme4"),
  nperm = 1000,
  type = "regression",
  progress = TRUE
)
}
\arguments{
\item{formula}{A normal formula, possibly using \code{lme4}-style random effects. This can also be a buildmer terms object, provided \code{dep} is passed in \code{buildmerControl}. Only a single response variable is supported. For binomial models, the \code{cbind} syntax is not supported; please convert your dependent variable to a proportion and use weights instead.}

\item{data}{The data.}

\item{family}{The family.}

\item{weights}{An optional vector of prior case weights. This vector is evaluated in the calling environment, not in the formula or data frame!}

\item{offset}{An optional vector containing a prior offset term. This vector is evaluated in the calling environment, not in the formula or data frame!}

\item{buildmerControl}{Options overriding the defaults in \code{buildmerControl}.}

\item{nperm}{The number of permutations.}

\item{type}{A character string of either \code{'anova'} or \code{'regression'}. The former runs an analysis of variance and returns F-values and p-values based on the explained variance of each factor in the design. The latter runs a linear-regression analysis and returns t-values and p-values based on individual effects. When running ANOVA, it is advised to use orthogonal predictors, as type III sums of squares are used.}

\item{progress}{Logical indicating whether to print progress messages during the permutation testing.}
}
\value{
A data frame.
}
\description{
A general permutation test for mixed-effects models or other \code{buildmer} models. This is an alias for \code{perm.lmer}, except that random effects are explicily disallowed.
}
\details{
If not explicitly overridden in the \code{buildmerControl} argument, the function changes a few buildmer defaults to make more sense for permutation testing. This includes setting \code{direction='order'} and \code{quiet=TRUE}. Set these options explicitly to override this behavior.
Because model comparisons are used for efficient permutation testing, REML is not supported.
Omega squared is not available for mixed-effects ANOVA; the \code{w2} column will not be included in the resulting \code{permutes} object.
The returned object provides the raw bootstrap samples in the \code{pb} attribute. These are used to compute a corrected p-value using Maris & Oostenveld's (2007) cluster mass statistic, but can also be used by the user to compute other such statistics. These obviously significantly increase the size of the R object; if this becomes a problem, there is no harm in deleting them using e.g. \code{attr(x,'perms') <- NULL}.
}
\examples{
\donttest{
# Testing a single EEG electrode, with random effects by participants
perms <- perm.lm(Fz ~ Deviant * Session,data=MMN[MMN$Time > 150 & MMN$Time < 250,])
# Testing a single EEG electrode, with random effects by participants, ANOVA inference
perms <- perm.lm(Fz ~ Deviant * Session,data=MMN[MMN$Time > 150 & MMN$Time < 250,],type='anova')
}
\dontshow{
perms <- perm.lm(Fz ~ Deviant*Session,data=MMN[MMN$Time > 200 & MMN$Time < 205,],nperm=2,type='anova')
perms <- perm.lm(Fz ~ Deviant*Session,data=MMN[MMN$Time > 200 & MMN$Time < 205,],nperm=2,type='regression')
perms <- perm.lm(Fz ~ Session,data=within(MMN[MMN$Time > 200 & MMN$Time < 205,],{Session <- factor(Session)}),nperm=2,type='regression')
}
}
