% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_subgroup_effects.R
\name{subgroup.effects}
\alias{subgroup.effects}
\title{Computes treatment effects within various subgroups}
\usage{
subgroup.effects(benefit.scores, y, trt, cutpoint = 0,
  larger.outcome.better = TRUE, reference.trt = NULL)
}
\arguments{
\item{benefit.scores}{vector of estimated benefit scores}

\item{y}{The response vector}

\item{trt}{treatment vector with each element equal to a 0 or a 1, with 1 indicating
treatment status is active.}

\item{cutpoint}{numeric value for patients with benefit scores above which
(or below which if \code{larger.outcome.better = FALSE})
will be recommended to be in the treatment group}

\item{larger.outcome.better}{boolean value of whether a larger outcome is better. Set to \code{TRUE}
if a larger outcome is better and set to \code{FALSE} if a smaller outcome is better. Defaults to \code{TRUE}.}

\item{reference.trt}{index of which treatment is the reference (in the case of multiple treatments).
This should be known already, as for a \code{trt} with K-levels, there will be K-1 benefit scores (1 per column)
of \code{benefit.scores}, where each column is a comparison of each K-1 treatments with the reference treatment.
The default is the last level of \code{trt} if it is a factor.}
}
\description{
Computes treatment effects within various subgroups to estimate subgroup treatment effects
}
\seealso{
\code{\link[personalized]{fit.subgroup}} for function which fits subgroup identification models which generate
benefit scores.
}
