% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardErrorIRT.R
\name{standardErrorIRT}
\alias{standardErrorIRT}
\title{Standard Error of Measurement (IRT).}
\usage{
standardErrorIRT(information)
}
\arguments{
\item{information}{Test information.}
}
\value{
Standard error of measurement for that amount of test information.
}
\description{
Estimate the standard error of measurement in item response theory.
}
\details{
Estimate the standard error of measurement in item response theory using the
test information (i.e., the sum of all items' information).
}
\examples{
# Calculate information for 4 items
item1 <- itemInformation(b = -2, a = 0.6, theta = -4:4)
item2 <- itemInformation(b = -1, a = 1.2, theta = -4:4)
item3 <- itemInformation(b = 1, a = 1.5, theta = -4:4)
item4 <- itemInformation(b = 2, a = 2, theta = -4:4)

items <- data.frame(item1, item2, item3, item4)

# Calculate test information
items$testInformation <- rowSums(items)

# Calculate standard error of measurement
standardErrorIRT(items$testInformation)

}
\seealso{
\doi{10.1177/0146621613475471}

Other IRT: 
\code{\link{discriminationToFactorLoading}()},
\code{\link{fourPL}()},
\code{\link{itemInformation}()},
\code{\link{reliabilityIRT}()}
}
\concept{IRT}
