% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semPlotInteraction.R
\name{semPlotInteraction}
\alias{semPlotInteraction}
\title{Plot interaction from SEM model.}
\usage{
semPlotInteraction(
  data,
  fit,
  predictor,
  centered_predictor,
  moderator,
  centered_moderator,
  interaction,
  outcome,
  covariates = NULL,
  predStr = NULL,
  modStr = NULL,
  outStr = NULL
)
}
\arguments{
\item{data}{the dataframe object from which the model was derived}

\item{fit}{the fitted model lavaan object}

\item{predictor}{the variable name of the predictor variable that is in its
raw metric (in quotes)}

\item{centered_predictor}{the variable name of the mean-centered predictor
variable as it appears in the model object syntax in lavaan (in quotes)}

\item{moderator}{the variable name of the moderator variable that is in its
raw metric (in quotes)}

\item{centered_moderator}{the variable name of the mean-centered moderator
variable that as it appears in the model object syntax in lavaan (in quotes)}

\item{interaction}{the variable name of the interaction term as it appears in
the model object syntax in lavaan (in quotes)}

\item{outcome}{the variable name of the outcome variable as it appears in the
model object syntax in lavaan (in quotes)}

\item{covariates}{default NULL; a vector of the names of the covariate
variables as they appear in the model object syntax in lavaan (each in
quotes)}

\item{predStr}{default NULL; optional addition of an x-axis title for the
name of the predictor variable (in quotes); if left unset,
plot label will default to "Predictor"}

\item{modStr}{default NULL; optional addition of an z-axis title for the
name of the moderator variable (in quotes); if left unset,
plot label will default to "Moderator"}

\item{outStr}{default NULL; optional addition of an x-axis title for the
name of the outcome variable (in quotes); if left unset,
plot label will default to "Outcome"}
}
\value{
Plot of two-way interaction from structural equation model.
}
\description{
Generates a plot of a 2-way interaction from a structural equation model
(SEM) that was estimated using the lavaan package.
}
\details{
Created by Johanna Caskey (johanna-caskey@uiowa.edu).
}
\examples{
states <- as.data.frame(state.x77)
names(states)[which(names(states) == "HS Grad")] <- "HS.Grad"
states$Income_rescaled <- states$Income/100

# Mean Center Predictors
states$Illiteracy_centered <- scale(states$Illiteracy, scale = FALSE)
states$Murder_centered <- scale(states$Murder, scale = FALSE)

# Compute Interaction Term
states$interaction <- states$Illiteracy_centered * states$Murder_centered

# Specify model syntax
moderationModel <- '
  Income_rescaled ~ Illiteracy_centered + Murder_centered + interaction +
  HS.Grad
'

# Fit the model
moderationFit <- lavaan::sem(
  moderationModel,
  data = states,
  missing = "ML",
  estimator = "MLR",
  fixed.x = FALSE)

# Pass model to function (unlabeled plot)
semPlotInteraction(
  data = states,
  fit = moderationFit,
  predictor = "Illiteracy",
  centered_predictor = "Illiteracy_centered",
  moderator = "Murder",
  centered_moderator = "Murder_centered",
  interaction = "interaction",
  outcome = "Income_rescaled",
  covariates = "HS.Grad")

# Pass model to function (labeled plot)
semPlotInteraction(
  data = states,
  fit = moderationFit,
  predictor = "Illiteracy",
  centered_predictor = "Illiteracy_centered",
  moderator = "Murder",
  centered_moderator = "Murder_centered",
  interaction = "interaction",
  outcome = "Income_rescaled",
  covariates = "HS.Grad",
  predStr = "Illiteracy Level",
  modStr = "Murder Rate",
  outStr = "Income")
}
\seealso{
Other plot: 
\code{\link{addText}()},
\code{\link{plot2WayInteraction}()},
\code{\link{ppPlot}()},
\code{\link{vwReg}()}

Other multipleRegression: 
\code{\link{lmCombine}()},
\code{\link{plot2WayInteraction}()},
\code{\link{ppPlot}()},
\code{\link{update_nested}()}

Other structural equation modeling: 
\code{\link{equiv_chi}()},
\code{\link{make_esem_model}()},
\code{\link{puc}()},
\code{\link{satorraBentlerScaledChiSquareDifferenceTestStatistic}()}
}
\concept{multipleRegression}
\concept{plot}
\concept{structural equation modeling}
