% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/phy.build.R
\name{phy.build}
\alias{bind.replace}
\alias{congeneric.merge}
\alias{phy.build}
\title{Build a novel phylogeny from existing data (based on
phyloGenerator)}
\usage{
congeneric.merge(tree, species, split = "_", ...)

bind.replace(backbone, donor, replacing.tip.label, donor.length = NA)
}
\arguments{
\item{tree}{\code{\link[ape:phylo]{phylo}} phylogeny to have those
species inserted into it}

\item{species}{vector of species names to be bound into the tree if
missing from it}

\item{split}{the character that splits genus and species names in
your phylogeny. Default is \code{_}, i.e. Quercus_robur.}

\item{...}{ignored}

\item{backbone}{backbone phylogeny (\code{\link[ape:phylo]{phylo}})
into which the donor is to be bound}

\item{donor}{phylogeny (\code{\link[ape:phylo]{phylo}}) to bound
into the backbone phylogeny}

\item{replacing.tip.label}{the species in the donor phylogeny
that's being replaced by the donor phylogeny}

\item{donor.length}{how deep the donor phylogeny should be cut into
the backbone phylogeny. If NA (default), then the bladj algorithm
is followed (or, in plain English, it's put half-way along the
branch)}
}
\value{
\code{\link[ape:phylo]{phylo}} phylogeny

phylogeny (\code{\link[ape:phylo]{phylo}})
}
\description{
Build a novel phylogeny from existing data (based on
phyloGenerator)
}
\details{
\code{congeneric.merge} Binds missing species into a
phylogeny by replacing all members of the clade it belongs to with
a polytomy. Assumes the \code{tip.labels} represent Latin
binomials, split by the \code{split} argument. This code was
originally shipped with phyloGenerator - this is the \code{merge}
method in that program.

\code{bind.replace} Binds a phylogeny (donor) into a
bigger phylogeny ('backbone'); useful if you're building a
phylogeny a la Phylomatic. A version of this R code was shipped
with phyloGenerator (Pearse & Purvis 2013). This is really an
internal function for \code{congeneric.merge}, but hopefully it's
of some use to you!
}
\examples{
tree <- read.tree(text="((a_a:1,b_b:1):1, c_c:2):1;")
tree <- congeneric.merge(tree, c("a_nother", "a_gain", "b_sharp"))
}
\author{
Will Pearse

Will Pearse
}
\references{
Pearse W.D. & Purvis A. phyloGenerator: an automated phylogeny generation tool for ecologists. Methods in Ecology and Evolution 4(7): 692--698.
}

