% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\name{pez.dispersion}
\alias{pez.dispersion}
\title{Calculate (phylogenetic) dispersion: examine assemblages in the
context of a source pools}
\usage{
pez.dispersion(data, null.model = c("taxa.labels", "richness",
  "frequency", "sample.pool", "phylogeny.pool", "independentswap",
  "trialswap"), abundance = FALSE, sqrt.phy = FALSE,
  traitgram = NULL, traitgram.p = 2, ext.dist = NULL,
  permute = 1000, ...)
}
\arguments{
\item{data}{\code{\link{comparative.comm}} object}

\item{null.model}{one of "taxa.labels", "richness", "frequency",
"sample.pool", "phylogeny.pool", "independentswap", or
"independentswap". These correspond to the null models available in
\code{\link{picante}}; only \code{d} does not use these null models}

\item{abundance}{Whether to use abundance-weighted forms of these
metrics (default: FALSE). D, which is presence/absence only, and so
will not be calculated when \code{TRUE}.}

\item{sqrt.phy}{If TRUE (default is FALSE) your phylogenetic
distance matrix will be square-rooted; specifying TRUE will force
the square-root transformation on phylogenetic distance matrices
(in the spirit of Leitten and Cornwell, 2014). See `details' for
details about different metric calculations when a distance matrix
is used.}

\item{traitgram}{If not NULL (default), a number to be passed to
\code{funct.phylo.dist} (\code{phyloWeight}; the `a' parameter),
causing analysis on a distance matrix reflecting both traits and
phylogeny (0 --> only phylogeny, 1 --> only traits; see
\code{funct.phylo.dist}). If a vector of numbers is given,
\code{pez.dispersion} iterates across them and returns a \code{data.frame}
with coefficients from each iteration. See `details' for details
about different metric calculations when a distance matrix is used.}

\item{traitgram.p}{A value for `p' to be used in conjunction with
\code{traitgram} when calling \code{funct.phylo.dist}.}

\item{ext.dist}{Supply an external species-level distance matrix
for use in calculations. See `details' for comments on the use of
distance matrices in different metric calculations.}

\item{permute}{number of null permutations to perform (default
1000)}

\item{...}{additional parameters to be passed to metrics (unlikely
you will want to use this!)}
}
\value{
a \code{data.frame} with metric values
}
\description{
As described in Pearse et al. (2014), a dispersion metric is one
the examines the phylogenetic structure of species present in each
assemblage in the context of a source pool of potentially present
species. Unlike other metrics, the value of a dispersion metric is
*contingent* on the definition of source pool, and (often)
randomisations used to conduct that comparison. For completeness,
options are provided to calculate these metrics using species
traits.
}
\details{
Most of these metrics do not involve comparison with some kind of
evolutionary-derived expectation for phylogenetic shape. Those that
do, however, such as D, make no sense unless applied to a
phylogenetic distance matrix - their null expectation *requires*
it. Using square-rooted distance matrices, or distance matrices
that incorporate trait information, can be an excellent thing to
do, but (for the above reasons), \code{pez} won't give you an
answer for metrics for which WDP thinks it makes no sense. SESpd
can (...up to you whether it should!...) be used with a
square-rooted distance matrix, but the results *will always be
wrong* if you do not have an ultrametric tree (branch lengths
proportional to time) and you will be warned about this. WDP
strongly feels you should only be using ultrametric phylogenies in
any case, but code to fix this bug is welcome.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
\dontrun{pez.dispersion(data)}
pez.dispersion(data, permute = 100)
}
\references{
Pearse W.D., Purvis A., Cavender-Bares J. & Helmus
M.R. (2014). Metrics and Models of Community Phylogenetics. In:
Modern Phylogenetic Comparative Methods and Their Application in
Evolutionary Biology. Springer Berlin Heidelberg, pp. 451-464.

\code{sesmpd,sesmntd} Webb C.O. (2000). Exploring the
phylogenetic structure of ecological communities: An example for
rain forest trees. American Naturalist, 156, 145-155.

\code{sespd} Webb C.O., Ackerly D.D. & Kembel
S.W. (2008). Phylocom: software for the analysis of phylogenetic
community structure and trait evolution. Bioinformatics
Applications Note, 24, 2098-2100.

\code{innd,mipd} Ness J.H., Rollinson E.J. & Whitney
K.D. (2011). Phylogenetic distance can predict susceptibility to
attack by natural enemies. Oikos, 120, 1327-1334.

\code{d} Fritz S.A. & Purvis A. (2010). Selectivity in
Mammalian Extinction Risk and Threat Types: a New Measure of
Phylogenetic Signal Strength in Binary Traits. Conservation
Biology, 24, 1042-1051.
}
\seealso{
\code{\link{pez.shape}} \code{\link{pez.evenness}} \code{\link{pez.dissimilarity}}
}
\author{
M.R. Helmus, Will Pearse
}
