% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{dropPROCEDURE}
\alias{dropPROCEDURE}
\title{Generate a postgreSQL DROP PROCEDURE statement, optionally execute the statement if con is not NULL.}
\usage{
dropPROCEDURE(
  name,
  args = NULL,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for postgreSQL DROP PROCEDURE.}

\item{args}{A named list, names are the argument names, values are strings with the argument data types.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to postgreSQL DROP PROCEDURE statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to postgreSQL DROP PROCEDURE statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to postgreSQL DROP PROCEDURE statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL DROP PROCEDURE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL DROP PROCEDURE statement, optionally execute the statement if con is not NULL.
}
\examples{
dropPROCEDURE(
name = "sample",
args = list(a = "INTEGER", b = "TEXT")
)
}
