% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{dropTRIGGER}
\alias{dropTRIGGER}
\title{Generate a postgreSQL DROP TRIGGER statement, optionally execute the statement if con is not NULL.}
\usage{
dropTRIGGER(
  name,
  on,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for postgreSQL DROP TRIGGER.}

\item{on}{A string, the "table_name" parameter for postgreSQL DROP TRIGGER.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to postgreSQL DROP TRIGGER statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to postgreSQL DROP TRIGGER statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to postgreSQL DROP TRIGGER statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL DROP TRIGGER statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL DROP TRIGGER statement, optionally execute the statement if con is not NULL.
}
\examples{
dropTRIGGER(
name = "sample_trigger",
on = "sample_table"
)
}
