% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{dropTABLE}
\alias{dropTABLE}
\title{Generate a PostgreSQL DROP TABLE statement, optionally execute the statement if con is not NULL.}
\usage{
dropTABLE(
  name,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for PostgreSQL DROP TABLE.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to PostgreSQL DROP TABLE statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to PostgreSQL DROP TABLE statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to PostgreSQL DROP TABLE statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL DROP TABLE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL DROP TABLE statement, optionally execute the statement if con is not NULL.
}
\examples{
dropTABLE("sample")
}
