/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.shadings;

import java.util.ArrayList;
import java.util.List;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.functions.PSFunction;
import net.sf.eps2pgf.ps.resources.shadings.RadialShading;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shading {
    private PSFunction function;
    private double t0;
    private double t1;

    public static Shading newShading(PSObjectDict pSObjectDict) throws PSError {
        RadialShading radialShading;
        PSObject pSObject = pSObjectDict.lookup("ShadingType");
        if (pSObject == null) {
            throw new PSErrorRangeCheck();
        }
        switch (pSObject.toInt()) {
            case 3: {
                radialShading = new RadialShading(pSObjectDict);
                break;
            }
            default: {
                throw new PSErrorUnimplemented("Shading type " + pSObject.toInt());
            }
        }
        return radialShading;
    }

    void loadCommonEntries(PSObjectDict pSObjectDict) throws PSError {
        PSObject pSObject = pSObjectDict.get("Function");
        if (!(pSObject instanceof PSObjectDict)) {
            if (pSObject instanceof PSObjectArray) {
                throw new PSErrorUnimplemented("Defining a function with an array");
            }
            throw new PSErrorTypeCheck();
        }
        this.function = PSFunction.newFunction(pSObject.toDict());
        PSObjectArray pSObjectArray = pSObjectDict.lookup("Domain").toArray();
        if (pSObjectArray == null) {
            this.t0 = 0.0;
            this.t1 = 1.0;
        } else {
            this.t0 = pSObjectArray.get(0).toReal();
            this.t1 = pSObjectArray.get(1).toReal();
        }
    }

    public double[] getColor(double d) throws PSErrorRangeCheck, PSErrorUnimplemented {
        double d2 = d * (this.t1 - this.t0) + this.t0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = this.function.evaluate(dArray);
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i] < 0.0) {
                dArray2[i] = 0.0;
                continue;
            }
            if (!(dArray2[i] > 1.0)) continue;
            dArray2[i] = 1.0;
        }
        return dArray2;
    }

    public double[] fitLinearSegmentsOnColor(double d) throws PSErrorUnimplemented {
        int n = 101;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i / ((double)n - 1.0);
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n);
        try {
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.getColor(dArray[i]));
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n2 = 0;
        arrayList2.add(dArray[0]);
        for (int i = 2; i < n; ++i) {
            double d2 = this.getMaxError(dArray, arrayList, n2, i);
            if (!(d2 > d)) continue;
            n2 = i - 1;
            arrayList2.add(dArray[i - 1]);
        }
        arrayList2.add(dArray[n - 1]);
        double[] dArray2 = new double[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            dArray2[i] = (Double)arrayList2.get(i);
        }
        return dArray2;
    }

    double getMaxError(double[] dArray, List<double[]> list, int n, int n2) {
        double d = 0.0;
        double[] dArray2 = list.get(n);
        double[] dArray3 = list.get(n2);
        for (int i = n + 1; i < n2; ++i) {
            double[] dArray4 = list.get(i);
            for (int j = 0; j < dArray2.length; ++j) {
                double d2 = (dArray[i] - dArray[n]) / (dArray[n2] - dArray[n]);
                double d3 = dArray2[j] + d2 * (dArray3[j] - dArray2[j]);
                double d4 = Math.abs(d3 - dArray4[j]);
                d = Math.max(d, d4);
            }
        }
        return d;
    }
}

