/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.errors.PSErrorDictStackUnderflow;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidAccess;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorStackUnderflow;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectNull;
import net.sf.eps2pgf.ps.objects.PSObjectOperator;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.Encoding;
import net.sf.eps2pgf.util.ArrayStack;

public class DictStack {
    private ArrayStack<PSObjectDict> dictStack = new ArrayStack();
    private PSObjectDict userdict = new PSObjectDict();
    private PSObjectDict globaldict = new PSObjectDict();
    private PSObjectDict systemdict = new PSObjectDict();

    public DictStack(Interpreter interpreter) {
        this.fillSystemDict(interpreter);
        try {
            this.systemdict.readonly();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
    }

    public void checkAccess(boolean bl, boolean bl2, boolean bl3) throws PSErrorInvalidAccess, PSErrorStackUnderflow {
        if (this.dictStack.size() > 0) {
            this.dictStack.peek().checkAccess(bl, bl2, bl3);
        } else {
            this.userdict.checkAccess(bl, bl2, bl3);
        }
    }

    public void cleardictstack() {
        try {
            while (true) {
                this.dictStack.pop();
            }
        }
        catch (PSErrorStackUnderflow pSErrorStackUnderflow) {
            return;
        }
    }

    int countdictstack() {
        return 3 + this.dictStack.size();
    }

    public void def(PSObject pSObject, PSObject pSObject2) {
        try {
            PSObjectDict pSObjectDict = this.dictStack.peek();
            pSObjectDict.setKey(pSObject, pSObject2);
        }
        catch (PSErrorStackUnderflow pSErrorStackUnderflow) {
            this.userdict.setKey(pSObject, pSObject2);
        }
    }

    public PSObjectArray dictstack(PSObjectArray pSObjectArray) throws PSErrorRangeCheck {
        int n = this.countdictstack();
        if (n > pSObjectArray.length()) {
            throw new PSErrorRangeCheck();
        }
        pSObjectArray.put(0, (PSObject)this.systemdict);
        pSObjectArray.put(1, (PSObject)this.globaldict);
        pSObjectArray.put(2, (PSObject)this.userdict);
        for (int i = 0; i < this.dictStack.size(); ++i) {
            pSObjectArray.put(i + 3, (PSObject)this.dictStack.get(i));
        }
        return pSObjectArray.getinterval(0, n);
    }

    public void dumpFull() throws PSErrorRangeCheck {
        System.out.println("----- Dictionary stack");
        for (int i = this.dictStack.size() - 1; i >= 0; --i) {
            PSObjectDict pSObjectDict = (PSObjectDict)this.dictStack.get(i);
            System.out.println("  --- dict" + i);
            pSObjectDict.dumpFull("    - ");
        }
        System.out.println("  --- userdict");
        this.userdict.dumpFull("    - ");
        System.out.println("  --- systemdict");
        System.out.println("    - " + this.systemdict.length() + " key->value pairs.");
        System.out.println("----- End of dictionary stack");
    }

    private void fillSystemDict(Interpreter interpreter) {
        int n;
        Object object;
        PSObject[] pSObjectArray;
        Object object2;
        Method[] methodArray = interpreter.getClass().getMethods();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sqBrackLeft", "[");
        hashMap.put("sqBrackRight", "]");
        hashMap.put("dblLessBrackets", "<<");
        hashMap.put("dblGreaterBrackets", ">>");
        hashMap.put("isis", "==");
        for (int i = 0; i < methodArray.length; ++i) {
            object2 = methodArray[i];
            pSObjectArray = ((Method)object2).getName();
            if (!pSObjectArray.startsWith("op_")) continue;
            if (hashMap.containsKey(pSObjectArray = pSObjectArray.substring(3))) {
                pSObjectArray = (String)hashMap.get(pSObjectArray);
            }
            object = new PSObjectOperator((String)pSObjectArray, (Method)object2);
            this.systemdict.setKey((String)pSObjectArray, (PSObject)object);
        }
        PSObjectDict pSObjectDict = new PSObjectDict();
        this.systemdict.setKey("errordict", (PSObject)pSObjectDict);
        object2 = new PSObjectDict();
        ((PSObjectDict)object2).setKey("newerror", (PSObject)new PSObjectBool(false));
        ((PSObjectDict)object2).setKey("errorname", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("command", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("errorinfo", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("ostack", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("estack", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("dstack", (PSObject)new PSObjectNull());
        ((PSObjectDict)object2).setKey("recordstacks", (PSObject)new PSObjectBool(true));
        ((PSObjectDict)object2).setKey("binary", (PSObject)new PSObjectBool(false));
        this.systemdict.setKey("$error", (PSObject)object2);
        this.systemdict.setKey("systemdict", (PSObject)this.systemdict);
        this.systemdict.setKey("userdict", (PSObject)this.userdict);
        this.systemdict.setKey("globaldict", (PSObject)this.globaldict);
        this.systemdict.setKey("statusdict", (PSObject)new PSObjectDict());
        this.systemdict.setKey("FontDirectory", (PSObject)interpreter.getResourceManager().getFontManager());
        pSObjectArray = Encoding.getISOLatin1Vector();
        this.systemdict.setKey("ISOLatin1Encoding", (PSObject)new PSObjectArray(pSObjectArray));
        pSObjectArray = Encoding.getStandardVector();
        this.systemdict.setKey("StandardEncoding", (PSObject)new PSObjectArray(pSObjectArray));
        this.systemdict.setKey("currentpacking", (PSObject)new PSObjectBool(false));
        this.systemdict.setKey("languagelevel", (PSObject)new PSObjectInt(3));
        object = "0.7.0";
        this.systemdict.setKey("version", (PSObject)new PSObjectString((String)object));
        try {
            n = Integer.parseInt(((String)object).replace(".", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.systemdict.setKey("revision", (PSObject)new PSObjectInt(n));
        this.systemdict.setKey("serialnumber", (PSObject)new PSObjectInt(0));
    }

    public void pushDict(PSObjectDict pSObjectDict) {
        this.dictStack.push(pSObjectDict);
    }

    public PSObjectDict peekDict() {
        try {
            return this.dictStack.peek();
        }
        catch (PSErrorStackUnderflow pSErrorStackUnderflow) {
            return this.userdict;
        }
    }

    public PSObjectDict popDict() throws PSErrorDictStackUnderflow {
        try {
            return this.dictStack.pop();
        }
        catch (PSErrorStackUnderflow pSErrorStackUnderflow) {
            throw new PSErrorDictStackUnderflow();
        }
    }

    public PSObjectDict where(PSObject pSObject) {
        for (int i = this.dictStack.size() - 1; i >= 0; --i) {
            PSObjectDict pSObjectDict = (PSObjectDict)this.dictStack.get(i);
            if (!pSObjectDict.known(pSObject)) continue;
            return pSObjectDict;
        }
        if (this.userdict.known(pSObject)) {
            return this.userdict;
        }
        if (this.globaldict.known(pSObject)) {
            return this.globaldict;
        }
        if (this.systemdict.known(pSObject)) {
            return this.systemdict;
        }
        return null;
    }

    public PSObject lookup(PSObject pSObject) {
        PSObjectDict pSObjectDict = this.where(pSObject);
        if (pSObjectDict == null) {
            return null;
        }
        return pSObjectDict.lookup(pSObject);
    }

    public PSObject lookup(String string) {
        return this.lookup(new PSObjectName(string, true));
    }

    public void store(PSObject pSObject, PSObject pSObject2) throws PSErrorTypeCheck {
        PSObjectDict pSObjectDict = this.where(pSObject);
        if (pSObjectDict == null) {
            this.def(pSObject, pSObject2);
        } else {
            pSObjectDict.setKey(pSObject, pSObject2);
        }
    }
}

