% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguMissings.R
\name{pgu.missings}
\alias{pgu.missings}
\title{pgu.missings}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Detects and substitutes missing values from data set.
}
\details{
Detects missing values in the transformed and normalized data set.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{imputationParameter}}{Returns the instance variable outliersParameter.
(tibble::tibble)}

\item{\code{imputationSites}}{Returns the instance variable imputationSites.
(tibble::tibble)}

\item{\code{one_hot_df}}{Returns the positions of missings in one_hot encoding
(tibble::tibble)}

\item{\code{amv}}{Returns the instance variable amv.
(numeric)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.missings$new()}}
\item \href{#method-finalize}{\code{pgu.missings$finalize()}}
\item \href{#method-print}{\code{pgu.missings$print()}}
\item \href{#method-resetImputationParameter}{\code{pgu.missings$resetImputationParameter()}}
\item \href{#method-featureIdx}{\code{pgu.missings$featureIdx()}}
\item \href{#method-filterFeatures}{\code{pgu.missings$filterFeatures()}}
\item \href{#method-gatherMeasurements}{\code{pgu.missings$gatherMeasurements()}}
\item \href{#method-gatherMissings}{\code{pgu.missings$gatherMissings()}}
\item \href{#method-gatherExistings}{\code{pgu.missings$gatherExistings()}}
\item \href{#method-gatherFractionOfMissings}{\code{pgu.missings$gatherFractionOfMissings()}}
\item \href{#method-gatherImputationStatistics}{\code{pgu.missings$gatherImputationStatistics()}}
\item \href{#method-one_hot}{\code{pgu.missings$one_hot()}}
\item \href{#method-detectImputationSites}{\code{pgu.missings$detectImputationSites()}}
\item \href{#method-imputationSiteDistribution}{\code{pgu.missings$imputationSiteDistribution()}}
\item \href{#method-imputationSiteHeatMap}{\code{pgu.missings$imputationSiteHeatMap()}}
\item \href{#method-clone}{\code{pgu.missings$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.missings} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be cleaned.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.missings} object.
(pguIMP::pgu.missings)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.missings} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.missings} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetImputationParameter"></a>}}
\if{latex}{\out{\hypertarget{method-resetImputationParameter}{}}}
\subsection{Method \code{resetImputationParameter()}}{
Resets instance variables and
identifies missings in the normalized data set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$resetImputationParameter(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Returns the position of an attribute within a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The postion of the attribute.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filterFeatures"></a>}}
\if{latex}{\out{\hypertarget{method-filterFeatures}{}}}
\subsection{Method \code{filterFeatures()}}{
Selects features cotaining missing values from a dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$filterFeatures(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The filtered data frame.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherMeasurements"></a>}}
\if{latex}{\out{\hypertarget{method-gatherMeasurements}{}}}
\subsection{Method \code{gatherMeasurements()}}{
Calculates the number of values of a vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$gatherMeasurements(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A vector comprising numeric data.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The lenght of the vector.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherMissings"></a>}}
\if{latex}{\out{\hypertarget{method-gatherMissings}{}}}
\subsection{Method \code{gatherMissings()}}{
Calculates the number of missing values of a vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$gatherMissings(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A vector comprising numeric data.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The number of missing in the vector.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherExistings"></a>}}
\if{latex}{\out{\hypertarget{method-gatherExistings}{}}}
\subsection{Method \code{gatherExistings()}}{
Calculates the number of existing values of a vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$gatherExistings(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A vector comprising numeric data.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The number of existing values in the vector.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherFractionOfMissings"></a>}}
\if{latex}{\out{\hypertarget{method-gatherFractionOfMissings}{}}}
\subsection{Method \code{gatherFractionOfMissings()}}{
Calculates the fraction of missing values of a vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$gatherFractionOfMissings(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A vector comprising numeric data.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fraction of missing values in the vector.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gatherImputationStatistics"></a>}}
\if{latex}{\out{\hypertarget{method-gatherImputationStatistics}{}}}
\subsection{Method \code{gatherImputationStatistics()}}{
Gathers statistical information about missing values
that are provided by the classes public \code{gather} functions.
The information is stored within the classes instance variable \code{imputationParameter}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$gatherImputationStatistics(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-one_hot"></a>}}
\if{latex}{\out{\hypertarget{method-one_hot}{}}}
\subsection{Method \code{one_hot()}}{
Gathers statistical information about missing values
in one hot format.
The result is stored in the instance variable one_hot_df.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$one_hot(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-detectImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-detectImputationSites}{}}}
\subsection{Method \code{detectImputationSites()}}{
Detects missing values within the data frame and
writes the to the instance variable \code{imputationsites}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$detectImputationSites(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputationSiteDistribution"></a>}}
\if{latex}{\out{\hypertarget{method-imputationSiteDistribution}{}}}
\subsection{Method \code{imputationSiteDistribution()}}{
Numeric representation of the distribution of missing values within the data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$imputationSiteDistribution(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame
(tibble::tibble)
#' @description
#' Merges the numeric attributes of the pguIMP data with its metadata.
#' @param data_df
#' The data frame to be analyzed.
#' (tibble::tibble)
#' @param metadata_df
#' The corresponding metadata.
#' (tibble::tibble)
#' @return
#' A data frame
#' (tibble::tibble)
mergeImputationSiteData = function(data_df = "tbl_df", metadata_df = "tbl_df"){
dfMerge <- data_df
if(nrow(data_df) == nrow(metadata_df)){
dfMerge <- dplyr::bind_cols(metadata_df, data_df)
}#if
dfMerge \%>\%
dplyr::filter_all(dplyr::any_vars(is.na(.))) \%>\%
return()
}, #function
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-imputationSiteHeatMap"></a>}}
\if{latex}{\out{\hypertarget{method-imputationSiteHeatMap}{}}}
\subsection{Method \code{imputationSiteHeatMap()}}{
Displays the distribution of missing values in form of a heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$imputationSiteHeatMap()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A heatmap plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missings$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
