% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguNormDist.R
\name{pgu.normDist}
\alias{pgu.normDist}
\title{pgu.normDist}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Compares the distribution of a single attribute's values to normal distribution
by using several statistic tests.
}
\details{
The distribution of a single value is tested for normality by
Shapiro-Wilk test, Kolmogorov-Smirnov test, Anderson-Darling test.
The expectation value and standard deviation of a normal distribution
representing the data are determined by maximizing the log Likelihood
with respect to the expectation value and standard deviation.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureName}}{Returns the instance variable featureName.
(character)}

\item{\code{rawData}}{Returns the instance variable rawData.
(tibble::tibble)}

\item{\code{setRawData}}{Sets the instance variable rawData.
(tibble::tibble)}

\item{\code{histogram}}{Returns the instance variable histogram.
(tibble::tibble)}

\item{\code{expMu}}{Returns the instance variable expMu.
(numeric)}

\item{\code{expSigma}}{Returns the instance variable expSigma.
(numeric)}

\item{\code{dataPoints}}{Returns the instance variable dataPoints.
(numeric)}

\item{\code{logLikelihood}}{Returns the instance variable logLikelihood.
(numeric)}

\item{\code{degOfFreedom}}{Returns the instance variable degOfFreedom.
(numeric)}

\item{\code{n}}{Returns the instance variable n.
(integer)}

\item{\code{bic}}{Returns the instance variable bic.
(numeric)}

\item{\code{aic}}{Returns the instance variable aic.
(numeric)}

\item{\code{aicc}}{Returns the instance variable aicc.
(numeric)}

\item{\code{rmse}}{Returns the instance variable rmse.
(numeric)}

\item{\code{fitSuccess}}{Returns the instance variable fitSuccess.
(logical)}

\item{\code{testNames}}{Returns the instance variable testNames.
(character)}

\item{\code{testParameterNames}}{Returns the instance variable testParameterNames.
(character)}

\item{\code{alpha}}{Returns the instance variable alpha.
(numeric)}

\item{\code{w.shapiro}}{Returns the instance variable w.shapiro.
(numeric)}

\item{\code{p.shapiro}}{Returns the instance variable p.shapiro.
(numeric)}

\item{\code{d.kolmogorow}}{Returns the instance variable d.kolmogorow.
(numeric)}

\item{\code{p.kolmogorow}}{Returns the instance variable p.kolmogorow.
(numeric)}

\item{\code{a.anderson}}{Returns the instance variable a.anderson.
(numeric)}

\item{\code{p.anderson}}{Returns the instance variable p.anderson.
(numeric)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.normDist$new()}}
\item \href{#method-finalize}{\code{pgu.normDist$finalize()}}
\item \href{#method-print}{\code{pgu.normDist$print()}}
\item \href{#method-resetNormDist}{\code{pgu.normDist$resetNormDist()}}
\item \href{#method-resetFail}{\code{pgu.normDist$resetFail()}}
\item \href{#method-optimize}{\code{pgu.normDist$optimize()}}
\item \href{#method-createHistogram}{\code{pgu.normDist$createHistogram()}}
\item \href{#method-normalQQData}{\code{pgu.normDist$normalQQData()}}
\item \href{#method-test.shapiro}{\code{pgu.normDist$test.shapiro()}}
\item \href{#method-test.kolmogorow}{\code{pgu.normDist$test.kolmogorow()}}
\item \href{#method-test.anderson}{\code{pgu.normDist$test.anderson()}}
\item \href{#method-fitResult}{\code{pgu.normDist$fitResult()}}
\item \href{#method-testResult}{\code{pgu.normDist$testResult()}}
\item \href{#method-testResultCompendium}{\code{pgu.normDist$testResultCompendium()}}
\item \href{#method-plotHistogram}{\code{pgu.normDist$plotHistogram()}}
\item \href{#method-plotResiduals}{\code{pgu.normDist$plotResiduals()}}
\item \href{#method-plotResidualDist}{\code{pgu.normDist$plotResidualDist()}}
\item \href{#method-plotRawResidualDist}{\code{pgu.normDist$plotRawResidualDist()}}
\item \href{#method-plotRawDataDist}{\code{pgu.normDist$plotRawDataDist()}}
\item \href{#method-normalQQPlot}{\code{pgu.normDist$normalQQPlot()}}
\item \href{#method-fit}{\code{pgu.normDist$fit()}}
\item \href{#method-clone}{\code{pgu.normDist$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.normDist} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.normDist} object.
(pguIMP::pgu.normDist)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.normDist} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.normDist} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetNormDist"></a>}}
\if{latex}{\out{\hypertarget{method-resetNormDist}{}}}
\subsection{Method \code{resetNormDist()}}{
Resets instance variables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$resetNormDist(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetFail"></a>}}
\if{latex}{\out{\hypertarget{method-resetFail}{}}}
\subsection{Method \code{resetFail()}}{
Resets instance variables in case of a failed analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$resetFail()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Optimizes the logLikelihood between the data and a normal distribution
with respect to the expectation value and standard deviation.
The quality of the best model ist calculated subsequently.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$optimize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createHistogram"></a>}}
\if{latex}{\out{\hypertarget{method-createHistogram}{}}}
\subsection{Method \code{createHistogram()}}{
Creates a histogram from the instance variable \code{rawData}.
The histogram is stored in the instance variable \code{histogram}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$createHistogram()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalQQData"></a>}}
\if{latex}{\out{\hypertarget{method-normalQQData}{}}}
\subsection{Method \code{normalQQData()}}{
Performes a qq-analysis of the instance variable \code{rawData}
The qq-analysis is stored in the attributes \code{sample_quantile}
and \code{theoretical_quantile} of the instance variable \code{rawData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$normalQQData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test.shapiro"></a>}}
\if{latex}{\out{\hypertarget{method-test.shapiro}{}}}
\subsection{Method \code{test.shapiro()}}{
Performes Shapiro-Wilk's test for normality on the
instance variable \code{rawData}.
The test result is stored in the instance variable
\code{w.shapiro}.
The p-value of the test is stored in the instance variable
\code{p.shapiro}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$test.shapiro()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test.kolmogorow"></a>}}
\if{latex}{\out{\hypertarget{method-test.kolmogorow}{}}}
\subsection{Method \code{test.kolmogorow()}}{
Performes Kolmogorow-Smirnow's test for normality on the
instance variable \code{rawData}.
The test result is stored in the instance variable
\code{d.kolmogorow}.
The p-value of the test is stored in the instance variable
\code{p.kolmogorow}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$test.kolmogorow()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test.anderson"></a>}}
\if{latex}{\out{\hypertarget{method-test.anderson}{}}}
\subsection{Method \code{test.anderson()}}{
Performes Anderson-Darling's test for normality on the
instance variable \code{rawData}.
The test result is stored in the instance variable
\code{a.anderson}.
The p-value of the test is stored in the instance variable
\code{p.anderson}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$test.anderson()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fitResult"></a>}}
\if{latex}{\out{\hypertarget{method-fitResult}{}}}
\subsection{Method \code{fitResult()}}{
Returns the result of the classes optimize function
in form of a formated string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$fitResult()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
String of the results of the fitting routine
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-testResult"></a>}}
\if{latex}{\out{\hypertarget{method-testResult}{}}}
\subsection{Method \code{testResult()}}{
Returns the result of the classes test functions
in form of a formated string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$testResult(testName = "Shapiro-Wilk")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testName}}{Defines the test which result shall be returned.
Can be of type:\code{Shapiro-Wilk}, \code{Kolmogorow-Smirnow}
or \code{Anderson-Darling}.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
String of the results of the testing routine
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-testResultCompendium"></a>}}
\if{latex}{\out{\hypertarget{method-testResultCompendium}{}}}
\subsection{Method \code{testResultCompendium()}}{
Returns the result of the classes test functions
\code{Shapiro-Wilk}, \code{Kolmogorow-Smirnow} and
\code{Anderson-Darling}
in form of a formated string.
(character)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$testResultCompendium()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
String of the results of the testing routine
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotHistogram"></a>}}
\if{latex}{\out{\hypertarget{method-plotHistogram}{}}}
\subsection{Method \code{plotHistogram()}}{
Displays the instance variable \code{histogram}
in form of a bar plot and overlays the corresponding normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$plotHistogram()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A bar plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotResiduals"></a>}}
\if{latex}{\out{\hypertarget{method-plotResiduals}{}}}
\subsection{Method \code{plotResiduals()}}{
Displays the residuals between the instance variable
\code{histogram} and the corresponding normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$plotResiduals()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A scatter plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotResidualDist"></a>}}
\if{latex}{\out{\hypertarget{method-plotResidualDist}{}}}
\subsection{Method \code{plotResidualDist()}}{
Displays the distribution of the residuals between the distribution of the instance variable
\code{histogram} in form of a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$plotResidualDist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A bar plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotRawResidualDist"></a>}}
\if{latex}{\out{\hypertarget{method-plotRawResidualDist}{}}}
\subsection{Method \code{plotRawResidualDist()}}{
Displays the distribution of the residuals between the distribution of the instance variable
\code{rawData} in form of a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$plotRawResidualDist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A bar plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotRawDataDist"></a>}}
\if{latex}{\out{\hypertarget{method-plotRawDataDist}{}}}
\subsection{Method \code{plotRawDataDist()}}{
Displays the distribution of the instance variable
\code{rawData} in form of a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$plotRawDataDist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A bar plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalQQPlot"></a>}}
\if{latex}{\out{\hypertarget{method-normalQQPlot}{}}}
\subsection{Method \code{normalQQPlot()}}{
Displays a qqplot of the instance variable
\code{rawData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$normalQQPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A qq-plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Runs the optimization process and performs all implemented quality controls.
Additionally performs hypothesis tests for nromality.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$fit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.normDist$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
