% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguCorrelator.R
\name{pgu.correlator}
\alias{pgu.correlator}
\title{pgu.correlator}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
An R6 class that performs pairwise correlation on the pguIMP data set.
}
\section{Construction}{

x <- pguIMP::pgu.correlator$new()
}

\examples{
require(dplyr)
require(tibble)
data(iris)
data_df <- iris \%>\%
  tibble::as_tibble() \%>\%
  dplyr::select(-c("Species"))
correlator = pguIMP::pgu.correlator$new(data_df)
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureNames}}{Returns the instance variable featureNames.
(character)}

\item{\code{setFeatureNames}}{Sets the instance variable featureNames.
It further initializes the instance variables:
intercept, pIntercept, slope, pSlope.
(character)}

\item{\code{method}}{Returns the instance variable method.
(character)}

\item{\code{r}}{Returns the instance variable r.
(matrix)}

\item{\code{pPearson}}{Returns the instance variable pPearson.
(matrix)}

\item{\code{tau}}{Returns the instance variable tau.
(matrix)}

\item{\code{pKendall}}{Returns the instance variable pKendall.
(matrix)}

\item{\code{rho}}{Returns the instance variable rho.
(matrix)}

\item{\code{pSpearman}}{Returns the instance variable pSpearman.
(matrix)}

\item{\code{abscissa}}{Returns the instance variable abscissa.
(character)}

\item{\code{setAbscissa}}{Sets the instance variable abscicca to value.}

\item{\code{ordinate}}{Returns the instance variable ordinate.
(character)}

\item{\code{setOrdinate}}{Sets the instance variable ordinate to value.}

\item{\code{test}}{Returns the instance variable test.
(stats::cor.test)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.correlator$new()}}
\item \href{#method-finalize}{\code{pgu.correlator$finalize()}}
\item \href{#method-print}{\code{pgu.correlator$print()}}
\item \href{#method-resetCorrelator}{\code{pgu.correlator$resetCorrelator()}}
\item \href{#method-resetMatrix}{\code{pgu.correlator$resetMatrix()}}
\item \href{#method-featureIdx}{\code{pgu.correlator$featureIdx()}}
\item \href{#method-calcCorrelationNumeric}{\code{pgu.correlator$calcCorrelationNumeric()}}
\item \href{#method-createCorrelationMatrixPearson}{\code{pgu.correlator$createCorrelationMatrixPearson()}}
\item \href{#method-createCorrelationMatrixKendall}{\code{pgu.correlator$createCorrelationMatrixKendall()}}
\item \href{#method-createCorrelationMatrixSpearman}{\code{pgu.correlator$createCorrelationMatrixSpearman()}}
\item \href{#method-correlate}{\code{pgu.correlator$correlate()}}
\item \href{#method-printFeature}{\code{pgu.correlator$printFeature()}}
\item \href{#method-printRTbl}{\code{pgu.correlator$printRTbl()}}
\item \href{#method-printPPearsonTbl}{\code{pgu.correlator$printPPearsonTbl()}}
\item \href{#method-printTauTbl}{\code{pgu.correlator$printTauTbl()}}
\item \href{#method-printPKendallTbl}{\code{pgu.correlator$printPKendallTbl()}}
\item \href{#method-printRhoTbl}{\code{pgu.correlator$printRhoTbl()}}
\item \href{#method-printPSpearmanTbl}{\code{pgu.correlator$printPSpearmanTbl()}}
\item \href{#method-clone}{\code{pgu.correlator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.correlator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.correlator} object.
(pguIMP::pgu.correlator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of \code{pgu.correlator} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.correlator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetCorrelator"></a>}}
\if{latex}{\out{\hypertarget{method-resetCorrelator}{}}}
\subsection{Method \code{resetCorrelator()}}{
Performes pair-wise correlation analysis on the attributes of the data frame.
Progresse is indicated by the progress object passed to the function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$resetCorrelator(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Dataframe with at least two numeric attributes.
(tibble::tibble)}

\item{\code{progress}}{Keeps track of the analysis progress.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-resetMatrix}{}}}
\subsection{Method \code{resetMatrix()}}{
Creates a square matrix which dimension corresponds to the length
of the instance variable featureNames. The matrix entries are set to a distict \code{value}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$resetMatrix(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value the matrix entries are set to.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A square matrix.
(matrix)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Determines the numerical index of the column of an attribute based on the attribute name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attributes column index.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calcCorrelationNumeric"></a>}}
\if{latex}{\out{\hypertarget{method-calcCorrelationNumeric}{}}}
\subsection{Method \code{calcCorrelationNumeric()}}{
Creates a correlation test between two attributes of a dataframe.
The test is stored as instance variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$calcCorrelationNumeric(
  abscissa = "numeric",
  ordinate = "numeric",
  method = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abscissa}}{The abscissa values.
(numeric)}

\item{\code{ordinate}}{The ordinate values.
(numeric)}

\item{\code{method}}{The cname of the correlation test.
Valid coiced are defined by the instance variable \code{method}.
(chatacter)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createCorrelationMatrixPearson"></a>}}
\if{latex}{\out{\hypertarget{method-createCorrelationMatrixPearson}{}}}
\subsection{Method \code{createCorrelationMatrixPearson()}}{
Performs the actual correlation test routine after Pearson.
Iteratively runs through the attributes known to the class
and calculates Pearson's correlation for each valid attribute pair.
The test results are stored in the instance variables:
r, pPearson.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixPearson(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createCorrelationMatrixKendall"></a>}}
\if{latex}{\out{\hypertarget{method-createCorrelationMatrixKendall}{}}}
\subsection{Method \code{createCorrelationMatrixKendall()}}{
Performs the actual correlation test routine after Kendall.
Iteratively runs through the attributes known to the class
and calculates Kendall's correlation for each valid attribute pair.
The test results are stored in the instance variables:
tau, pKendall.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixKendall(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createCorrelationMatrixSpearman"></a>}}
\if{latex}{\out{\hypertarget{method-createCorrelationMatrixSpearman}{}}}
\subsection{Method \code{createCorrelationMatrixSpearman()}}{
Performs the actual correlation test routine after Spearman.
Iteratively runs through the attributes known to the class
and calculates Spearman's correlation for each valid attribute pair.
The test results are stored in the instance variables:
rho, pSpearman.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$createCorrelationMatrixSpearman(
  data = "tbl_df",
  progress = "Progress"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correlate"></a>}}
\if{latex}{\out{\hypertarget{method-correlate}{}}}
\subsection{Method \code{correlate()}}{
Performs the all three correlation test routines defined
within the instance variable \code{method}.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$correlate(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be analysed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printFeature"></a>}}
\if{latex}{\out{\hypertarget{method-printFeature}{}}}
\subsection{Method \code{printFeature()}}{
Transforms the results of the correlation procedure for a valid pair of attributes to a dataframe
and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printFeature()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The analyis result as a dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printRTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printRTbl}{}}}
\subsection{Method \code{printRTbl()}}{
Transfroms instance variable \code{r} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printRTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{r}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printPPearsonTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printPPearsonTbl}{}}}
\subsection{Method \code{printPPearsonTbl()}}{
Transfroms instance variable \code{pPearson} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPPearsonTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{pPearson}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printTauTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printTauTbl}{}}}
\subsection{Method \code{printTauTbl()}}{
Transfroms instance variable \code{tau} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printTauTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{tau}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printPKendallTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printPKendallTbl}{}}}
\subsection{Method \code{printPKendallTbl()}}{
Transfroms instance variable \code{pKendall} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPKendallTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{pKendall}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printRhoTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printRhoTbl}{}}}
\subsection{Method \code{printRhoTbl()}}{
Transfroms instance variable \code{rho} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printRhoTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{rho}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printPSpearmanTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printPSpearmanTbl}{}}}
\subsection{Method \code{printPSpearmanTbl()}}{
Transfroms instance variable \code{pSpearman} to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$printPSpearmanTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable \code{pSpearman}.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.correlator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
