% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predp.R
\name{PredP.design}
\alias{PredP.design}
\title{The stopping boundaries based on the predictive probability criterion}
\usage{
PredP.design(type, nmax, a, b, p0, theta_t, delta, theta)
}
\arguments{
\item{type}{type of boundaries: "superiority" or "futility".}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{a}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{b}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{p0}{the the response rate for the standard drug.}

\item{theta_t}{the prespecified target probability; tipically, \eqn{\theta_T = [0.85, 0.95]}. Set 0.9 by default.}

\item{delta}{the minimally acceptable increment of the response rate for the experimental drug compared with the standard drug}

\item{theta}{the cutoff probability: typically, \eqn{\theta = [0.95, 0.99]} for efficacy, \eqn{\theta = [0.01, 0.05]} for futility.}
}
\value{
\item{boundset}{the boundaries set: \eqn{U_n} or \eqn{L_n}}
}
\description{
The design function to sequentially monitor sample size and boundary based on Lee and Liu's criterion.
}
\examples{
PredP.design(type = "futility", nmax=40, a=1, b=1, p0=0.15, delta=0.15, theta=0.05)
PredP.design(type = "efficacy", nmax=40, a=1, b=1, p0=0.15, delta=0.15, theta=0.9)
}
\references{
Lee, J. J., Liu, D. D. (2008).
A predictive probability design for phase II cancer clinical trials.
\emph{Clinical Trials} \strong{5}: 93-106.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

