% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{phacking_rtma}
\alias{phacking_rtma}
\title{Right-truncated meta-analysis}
\usage{
phacking_rtma(
  yi,
  vi,
  sei,
  favor_positive = TRUE,
  alpha_select = 0.05,
  stan_control = list(adapt_delta = 0.98, max_treedepth = 20),
  parallelize = TRUE
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{favor_positive}{\code{TRUE} if p-hacking and publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by p-hacking and/or by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{stan_control}{List passed to \code{rstan::sampling()} as the
\code{control} argument.}

\item{parallelize}{Logical indicating whether to parallelize sampling.}
}
\value{
An object of class \code{metabias}, which is list with four elements:
\describe{
\item{data}{A tibble with one row per study and the columns \code{yi},
\code{vi}, \code{sei}, and \code{affirm} (logical indicating
whether the study result is affirmative).}
\item{values}{A vector with the elements \code{k} (number of studies),
\code{k_affirmative} (number of affirmative studies),
\code{k_nonaffirmative} (number of nonaffirmative studies),
\code{favor_positive} (as passed to \code{phacking_rtma()}),
\code{alpha_select} (as passed to \code{phacking_rtma()}),
\code{tcrit} (critical t-value based on \code{alpha_select}),
and \code{optim_converged} (logical indicating whether the
optimization to find the posterior mode converged).}
\item{stats}{A tibble with two rows and the columns \code{param} (mu, tau),
\code{mode}, \code{median}, \code{mean}, \code{se},
\code{ci_lower}, \code{ci_upper}, \code{n_eff}, and
\code{r_hat}. We recommend reporting the \code{mode} for the
point estimate; \code{median} and \code{mean} represent
posterior medians and means respectively.}
\item{fit}{A \code{stanfit} object (the result of fitting the RTMA model).}
}
}
\description{
Fits right-truncated meta-analysis (RTMA), a bias correction for the joint
effects of p-hacking (i.e., manipulation of results within studies to obtain
significant, positive estimates) and traditional publication bias (i.e., the
selective publication of studies with significant, positive results) in
meta-analyses.
}
\examples{
\donttest{
set.seed(22)
phacking_rtma(lodder$yi, lodder$vi, parallelize = FALSE)
}
}
\references{
\insertRef{mathur2022}{phacking}
}
