% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.phantom.batch.R
\name{run.phantom.batch}
\alias{run.phantom.batch}
\title{Run phantom batch analysis}
\usage{
run.phantom.batch(data = NULL, geneset_list = NULL, maxncluster = 5,
  nsample = 1000, report_pval = 0.05, report_nmin = 5,
  output_dir = file.path("./phantom_result"))
}
\arguments{
\item{data}{User provided time-course data loaded by load.data()}

\item{geneset_list}{User provided genesets list loaded by load.geneset(). Phanotm package provids four geneset lists from different resources: kegg, reactome, emory geneset and baylor modules. These genesets can be obtained with data(), e.g. data(kegg.geneset)}

\item{maxncluster}{The maximum number of clusters within a geneset user wants to test with. All numbers from 1 to ncluster will be tested and an optimal cluster number will be selected to identify the heterogeneity of this geneset.}

\item{nsample}{The times of random sampling that is used to build the NULL distribution for parato front analysis.}

\item{report_pval}{The maximum p value of a geneset that will be reported as a significant heterogeneous geneset. Genesets with p value larger than report_pval wil not be reported}

\item{report_nmin}{The minmum size of subcluster in a geneset that will be reported as a significant heterogeneous geneset.}

\item{output_dir}{The directory where user wants to put the phantom batch analysis results}
}
\description{
This function allows user to run batch analysis of a full geneset list with phantom, and download the identified heterogeneous genesets
}
\examples{
## load in the demo data and geneset in phantom package
data("time.course.data")
data("kegg.geneset")

## store the analysis result in an object
\dontrun{obj = run.phantom.batch(data = time.course.data, geneset_list = kegg.geneset,
                  maxncluster = 5, nsample = 1000, report_pval = 0.05, report_nmin = 5,
                  output_dir = file.path(getwd(),'/phantom_result'))}
}
\keyword{batch}
\keyword{phantom}
\keyword{run}
