% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{sample_parameters_from_covariance_matrix}
\alias{sample_parameters_from_covariance_matrix}
\title{sample_parameters_from_covariance_matrix}
\usage{
sample_parameters_from_covariance_matrix(
  model,
  modelfit_results = NULL,
  parameters = NULL,
  force_posdef_samples = NULL,
  force_posdef_covmatrix = FALSE,
  n = 1,
  rng = NULL
)
}
\arguments{
\item{model}{(Model) Input model}

\item{modelfit_results}{(ModelfitResults) Alternative results object. Default is to use the one in model}

\item{parameters}{(vector) Use to only sample a subset of the parameters. NULL means all}

\item{force_posdef_samples}{(integer) Set to how many iterations to do before forcing all samples to be positive definite. NULL is
default and means never and 0 means always}

\item{force_posdef_covmatrix}{(logical) Set to TRUE to force the input covariance matrix to be positive definite}

\item{n}{(integer) Number of samples}

\item{rng}{(Generator) Random number generator}
}
\value{
(data.frame) A dataframe with one sample per row
}
\description{
Sample parameter vectors using the covariance matrix

If modelfit_results is not provided the results from the model will be used
}
\examples{
\dontrun{
model <- load_example_model("pheno")
rng <- create_rng(23)
sample_parameters_from_covariance_matrix(model, n=3, rng=rng)
}
}
\seealso{
sample_parameters_uniformly : Sample parameter vectors using uniform distribution

sample_individual_estimates : Sample individual estiates given their covariance
}
