% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{has_presystemic_metabolite}
\alias{has_presystemic_metabolite}
\title{has_presystemic_metabolite}
\usage{
has_presystemic_metabolite(model)
}
\arguments{
\item{model}{(Model) Pharmpy model}
}
\value{
(logical) Whether a model has presystemic metabolite
}
\description{
Checks whether a model has a presystemic metabolite

If pre-systemic drug there will be a flow from DEPOT to METABOLITE as well
as being a flow from the CENTRAL to METABOLITE
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- add_metabolite(model, presystemic=TRUE)
has_presystemic_metabolite(model)
}

}
