% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_parameters_from_ucp}
\alias{calculate_parameters_from_ucp}
\title{calculate_parameters_from_ucp}
\usage{
calculate_parameters_from_ucp(model, scale, ucps)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{scale}{(UCPScale) A parameter scale}

\item{ucps}{(array or list(str=numeric)) Series of parameter values}
}
\value{
(data.frame) Parameters on the normal scale
}
\description{
Scale parameter values from ucp to normal scale
}
\examples{
\dontrun{
model <- load_example_model("pheno")
scale <- calculate_ucp_scale(model)
values <- list('POP_CL'=0.1, 'POP_VC'=0.1, 'COVAPGR'=0.1, 'IIV_CL'=0.1, 'IIV_VC'=0.1, 'SIGMA'=0.1)
calculate_parameters_from_ucp(model, scale, values)
}
}
\seealso{
calculate_ucp_scale : Calculate the scale for conversion from ucps
}
