% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{plot_abs_cwres_vs_ipred}
\alias{plot_abs_cwres_vs_ipred}
\title{plot_abs_cwres_vs_ipred}
\usage{
plot_abs_cwres_vs_ipred(
  model,
  predictions,
  residuals,
  stratify_on = NULL,
  bins = 8
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{predictions}{(data.frame) DataFrame containing the predictions}

\item{residuals}{(data.frame) DataFrame containing the residuals}

\item{stratify_on}{(str (optional)) Name of parameter for stratification}

\item{bins}{(numeric) Number of bins for stratification}
}
\value{
(alt.Chart) Plot
}
\description{
Plot \|CWRES\| vs IPRED
}
\examples{
\dontrun{
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_abs_cwres_vs_ipred(model, res$predictions, res$residuals)
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_abs_cwres_vs_ipred(model, res$predictions, res$residuals, 'WGT', bins=4)
}

}
