% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPeriodogramsAct.R
\name{allPeriodogramsAct}
\alias{allPeriodogramsAct}
\title{Periodogram analysis for activity data}
\usage{
allPeriodogramsAct(
  data,
  bin = 1,
  method = "ChiSquare",
  low.per = 16,
  high.per = 32,
  alpha = 0.05,
  time.res = 20
)
}
\arguments{
\item{data}{Input data file. If the method for analysis is "ChiSquare", then the input for this function must be the output of the function trimData(). See ??trimData(). Otherwise, the input for this function must be the output of the function binData(). See ??binData().}

\item{bin}{Intervals in which input data are sampled (in minutes). This defaults to 1. This must be changed appropriately depending on method of analysis and the input data set.}

\item{method}{Choose the method for performing time-series analysis. Currently, three methods are implemented for analysis - "ChiSquare", "Autocorrelation", and "LombScargle". This defaults to "ChiSquare".}

\item{low.per}{Choose the lowest period (in hours) for analysis. This defaults to 16.}

\item{high.per}{Choose the highest period (in hours) for analysis. This defaults to 32.}

\item{alpha}{Choose the significance level for periodogram analysis. This defaults to 0.05.}

\item{time.res}{Resolution of periods (in minutes) to analyse while using the "ChiSquare" periodogram. For instance, if users wish to scan periods from low.per to high.per in the following manner: 16, 16.5, 17, 17.5, and so on, then time.res must be 30. This defaults to 20.}
}
\value{
A \code{list} with two items:
\describe{
\item{Plots}{A \code{plotly} \code{htmlwidget} with all periodograms in a 4-by-8 array.}
\item{Data}{A \code{matrix} \code{array} with 32 rows (one for each fly) and 2 columns (Period and Adjusted Power).}
}
}
\description{
This function generates a composite figure with periodogram plots for all flies in a DAM scanned monitor file. Input for this function must be an output from the trimData() function. The output of this function is a list with two components - (a) large plotly object with periodogram plots for all flies, and (b) a table which has channel wise information of significant period and adjusted power values, from the chosen time-series analysis method. This function requires the packages "plotly" and "zeitgebr".
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 5, bin = 1, t.cycle = 24)
all.periodograms.act <- allPeriodogramsAct(data = td[,1:15])
}
