% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_phenocam.r
\name{read_phenocam}
\alias{read_phenocam}
\title{Read PhenoCam time series data}
\usage{
read_phenocam(filename)
}
\arguments{
\item{filename}{a PhenoCam data file}
}
\value{
A nested data structure including site meta-data, the full
header and the data as a `data.frame()`.
}
\description{
Reads PhenoCam data into a nested list, preserving
header data and critical file name information.
}
\examples{

\donttest{
# download demo data (do not smooth)
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3",
                  smooth = FALSE)

# read the phenocamo data file
df = read_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))

# print data structure
print(summary(df))

# write the phenocamo data file
write_phenocam(df, out_dir = tempdir())
}
}
\keyword{phenocam}
\keyword{series,}
\keyword{smoothing,}
\keyword{time}
