% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wWHIT.R
\name{whit2}
\alias{whit2}
\title{Weighted Whittaker smoothing with a second order finite difference penalty}
\usage{
whit2(y, lambda, w = rep(1, ny))
}
\arguments{
\item{y}{signal to be smoothed: a vector}

\item{lambda}{smoothing parameter: larger values lead to more smoothing}

\item{w}{weights: a vector of same length as y. Default weights are equal to one}
}
\value{
A numeric vector, smoothed signal.
}
\description{
This function smoothes signals with a finite difference penalty of order 2.
This function is modified from \code{ptw} package.
}
\examples{
library(phenofit)
data("MOD13A1")
dt <- tidy_MOD13(MOD13A1$dt)
y <- dt[site == "AT-Neu", ][1:120, y]

plot(y, type = "b")
lines(whit2(y, lambda = 2), col = 2)
lines(whit2(y, lambda = 10), col = 3)
lines(whit2(y, lambda = 100), col = 4)
legend("bottomleft", paste("lambda = ", c(2, 10, 15)), col = 2:4, lty = rep(1, 3))
}
\references{
\enumerate{
\item Eilers, P.H.C. (2004) "Parametric Time Warping", Analytical Chemistry,
\strong{76} (2), 404 -- 411. \cr
\item Eilers, P.H.C. (2003) "A perfect smoother", Analytical Chemistry,
\strong{75}, 3631 -- 3636.
}
}
\author{
Paul Eilers, Jan Gerretzen
}
