#' logLik.ECFOCF return Log Likelihood of a fit done using fitCF
#' @title Return Log Likelihood of a fit done using fitCF
#' @author Marc Girondot
#' @return The Log Likelihood value for the fitted model with data
#' @param object A result file generated by fitCF
#' @param ... Not used
#' @description Return Log Likelihood of a fit generated by fitCF.
#' @family Model of Clutch Frequency
#' @examples
#' \dontrun{
#' library(phenology)
#' # Example
#' ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002, date0=as.Date("2002-01-01"))
#' par <- c(mu = 2.6404831115214353, 
#'         size = 0.69362774786433479, 
#'         mu_season = 12.6404831115214353, 
#'         size_season = 1.69362774786433479, 
#'         a2=0)
#' fp <- rep(0, dim(ECFOCF_2002)[3])
#' names(fp) <- paste0("p.", formatC(1:(dim(ECFOCF_2002)[3]), width=2, flag="0"))
#' par <- c(par, fp[attributes(ECFOCF_2002)$table["begin"]:attributes(ECFOCF_2002)$table["end"]])
#' fixed.parameters <- c(a1=Inf, p=-Inf)
#' 
#'  lnLCF(x=par, data=ECFOCF_2002, fixed.parameters=fixed.parameters)
#'  
#'  o_mu1season1a2p <- fitCF(x=par, fixed.parameters=fixed.parameters, 
#'                           data=ECFOCF_2002)
#'  
#' logLik(o_mu1season1a2p)
#' AIC(o_mu1season1a2p)
#' }
#' @method logLik ECFOCF
#' @export


logLik.ECFOCF <- function(object, ...) {
  l <- -object$value
  n <- sum(object$data, na.rm=TRUE)
  attributes(l) <- list(nall=n , nobs=n , df=length(object$par) , class="logLik")
  return(l)
}
