\name{sinc}
\alias{sinc}
\title{
Sinc Function
}
\description{
Sample the sinc function at given points
}
\usage{
sinc (x, normalized = FALSE)
}
\arguments{
  \item{x}{A vector of x-axis points at which the sinc function will be sampled.} 
  \item{normalized}{If TRUE, a normalized sinc function is returned.} 
}
\details{
The formula for the unnormalized sinc function is y = sin(x)/x.

The formula for the normalized sinc function is y = sin(x*pi)/(x*pi).
}
\value{
A vector containing y-axis values for each specified x-axis value is returned.
}
\references{
http://en.wikipedia.org/wiki/Sinc_function

Lyons, R. G. (2004). Understanding Digital Signal Processing (2nd ed.). Prentice Hall.
}
\author{
Santiago Barreda <sbarreda@ucdavis.edu>
}
\examples{
x = seq(-20,20,.1)
## generate both forms of the sinc function between -20 and 20
y1 = sinc (x)
y2 = sinc (x, normalized = TRUE)
## the unnormalized sinc function has zero crossing at 
## integer multiples of pi
plot (x,y1, type = 'b')
## the normalized sinc function has zero crossing at integers
lines (x,y2, type = 'b', col = 4)
abline (h = 0)
}
