% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setHowMeasured}
\alias{setHowMeasured}
\alias{how_measured<-}
\title{Set the "how.measured" attribute}
\usage{
setHowMeasured(x, how.measured)

how_measured(x) <- value
}
\arguments{
\item{x}{a generic_spct object}

\item{how.measured, value}{a list}
}
\value{
x
}
\description{
Function to set by reference the "how.measured" attribute  of an existing
generic_spct or derived-class object.
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a generic_spct object, x is not
  modified.
}
\examples{

my.spct <- sun.spct
how_measured(my.spct)
how_measured(my.spct) <- "simulated with a radiation transfer model"
how_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
