% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.sum.r
\name{s_sum}
\alias{s_sum}
\alias{s_sum.default}
\alias{s_sum.generic_spct}
\alias{s_sum.filter_mspct}
\alias{s_sum.source_mspct}
\alias{s_sum.response_mspct}
\alias{s_sum.reflector_mspct}
\alias{s_sum.calibration_mspct}
\alias{s_sum.cps_mspct}
\alias{s_sum.raw_mspct}
\title{Sum from collection of spectra}
\usage{
s_sum(x, na.rm, ...)

\method{s_sum}{default}(x, na.rm = FALSE, ...)

\method{s_sum}{generic_spct}(x, na.rm = FALSE, ...)

\method{s_sum}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object is of same class as the
  members of the collection, such as \code{"filter_spct"}, containing the
  summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" sum of values across members of a
collection of spectra or of a spectral object containing multiple spectra in
long form.
}
\details{
Method specializations compute the sum at each wavelength across a
  group of spectra stored in an object of one of the classes defined in
  package 'photobiology'. Omission of NAs is done
  separately at each wavelength. Interpolation is not applied, so all spectra
  in \code{x} must share the same set of wavelengths. An error is triggered
  if this condition is nor fulfilled.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_sum(default)}: 

\item \code{s_sum(generic_spct)}: 

\item \code{s_sum(filter_mspct)}: 

\item \code{s_sum(source_mspct)}: 

\item \code{s_sum(response_mspct)}: 

\item \code{s_sum(reflector_mspct)}: 

\item \code{s_sum(calibration_mspct)}: 

\item \code{s_sum(cps_mspct)}: 

\item \code{s_sum(raw_mspct)}: 

}}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The methods accept
  as arguments objects of these classes only if spectra contain data for a
  single spectrometer scan. In the case of \code{cps_spct} objects, a single
  column can also contain data from multiple scans spliced into a single
  variable.

  The sum operation is meaningful only for certain physical
  quantities or bases of expression.
}
\examples{
s_sum(sun_evening.mspct)

}
\seealso{
See \code{\link[base]{sum}} for the \code{sum()} method used for
  the computations.
}
