#' @title Transmittance spectrum of clear polyester film
#'
#' @description A dataset containing the wavelengths at a 1 nm interval and
#'   fractional total transmittance for polyester film.
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 611 rows and 2 variables
#' @name polyester.spct
#' @family Spectral data examples
NULL

#' @title Transmittance spectrum of yellow theatrical gel.
#'
#' @description A dataset containing the wavelengths at a 1 nm interval and
#'   fractional total transmittance for polyester film.
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 611 rows and 2 variables
#' @name yellow_gel.spct
#' @family Spectral data examples
NULL

#' @title Theoretical spectrum of a clear clear material
#'
#' @description A dataset for a hypothetical object with transmittance 1/1
#'   (100\%)
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 4 rows and 2 variables
#' @name clear.spct
#' @family Spectral data examples
NULL

#' @title Theoretical spectrum of an opaque material
#'
#' @description A dataset for a hypothetical object with transmittance 0/1
#'   (0\%)
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 4 rows and 2 variables
#' @name opaque.spct
NULL
