% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{e2q}
\alias{e2q}
\alias{e2q.default}
\alias{e2q.source_spct}
\alias{e2q.response_spct}
\alias{e2q.source_mspct}
\alias{e2q.response_mspct}
\title{Convert energy-based quantities into photon-based quantities.}
\usage{
e2q(x, action, byref, ...)

\method{e2q}{default}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{response_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_mspct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{response_mspct}(x, action = "add", byref = FALSE, ...)
}
\arguments{
\item{x}{an R object}

\item{action}{a character string}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{...}{not used in current version}
}
\description{
Function that coverts spectral energy irradiance into spectral photon irradiance (molar).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{source_spct}: Method for spectral irradiance

\item \code{response_spct}: Method for spectral responsiveness

\item \code{source_mspct}: Method for collections of (light) source spectra

\item \code{response_mspct}: Method for for collections of response spectra
}}

\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2Afr}}, \code{\link{T2A}},
  \code{\link{T2T}}, \code{\link{as_energy}},
  \code{\link{as_quantum_mol}}, \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{q2e}}
}
