% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{peaks}
\alias{peaks}
\alias{peaks.default}
\alias{peaks.numeric}
\alias{peaks.generic_spct}
\alias{peaks.source_spct}
\alias{peaks.response_spct}
\alias{peaks.filter_spct}
\alias{peaks.reflector_spct}
\alias{peaks.cps_spct}
\alias{peaks.generic_mspct}
\title{Peaks or local maxima}
\usage{
peaks(x, span, ignore_threshold, strict, ...)

\method{peaks}{default}(x, span, ignore_threshold, strict, ...)

\method{peaks}{numeric}(x, span = 5, ignore_threshold, strict = TRUE, ...)

\method{peaks}{generic_spct}(x, span, ignore_threshold, strict, ...)

\method{peaks}{source_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, unit.out = getOption("photobiology.radiation.unit", default
  = "energy"), ...)

\method{peaks}{response_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, unit.out = getOption("photobiology.radiation.unit", default
  = "energy"), ...)

\method{peaks}{filter_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, filter.qty = getOption("photobiology.filter.qty", default =
  "transmittance"), ...)

\method{peaks}{reflector_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ...)

\method{peaks}{cps_spct}(x, span = 5, ignore_threshold = 0, strict = TRUE,
  ...)

\method{peaks}{generic_mspct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 3, meaning that a peak is bigger than both of
its neighbors. Default: 3.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the
relative size compared to tallest peak threshold below which peaks will be
ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{...}{ignored}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to local maxima.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function usable on numeric vectors.

\item \code{numeric}: Default function usable on numeric vectors.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{source_spct}: Method for "source_spct" objects.

\item \code{response_spct}: Method for "response_spct" objects.

\item \code{filter_spct}: Method for "filter_spct" objects.

\item \code{reflector_spct}: Method for "reflector_spct" objects.

\item \code{cps_spct}: Method for "cps_spct" objects.

\item \code{generic_mspct}: Method for "cps_spct" objects.
}}

\examples{
peaks(sun.spct)

}
\seealso{
Other peaks and valleys functions: \code{\link{find_peaks}},
  \code{\link{get_peaks}}, \code{\link{valleys}}
}
