% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative-am.r
\name{relative_AM}
\alias{relative_AM}
\title{Relative Air Mass (AM)}
\usage{
relative_AM(elevation.angle = NULL, zenith.angle = NULL,
  occluded.value = NA)
}
\arguments{
\item{elevation.angle, zenith.angle}{numeric vector Angle in degrees for the
sun position. An argument should be passed to one and only one of
\code{elevation_angle} or \code{zenith_angle}.}

\item{occluded.value}{numeric Value to return when elevation angle is
negative (sun below the horizon).}
}
\description{
Approximate relative air mass (AM) from sun elevation or
sun zenith angle.
}
\details{
This is an implementation of equation (3) in Kasten and Young
  (1989). This equation is only an approximation to the tabulated values in
  the same paper. Returned values are rounded to three significant digits.
}
\note{
Although relative air mass is not defined when the sun is not visible,
  returning a value different from the default \code{NA} might be useful in
  some cases.
}
\examples{

relative_AM(c(90, 60, 30, 1, -10))
relative_AM(c(90, 60, 30, 1, -10), occluded.value = Inf)
relative_AM(zenith.angle = 0)

}
\references{
F. Kasten, A. T. Young (1989) Revised optical air mass tables and
approximation formula. Applied Optics, 28, 4735-. doi:10.1364/ao.28.004735.
}
