% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.vapour.R
\name{water_vp_sat}
\alias{water_vp_sat}
\alias{water_dp}
\alias{water_vp2mvc}
\alias{water_mvc2vp}
\title{Water vapour pressure}
\usage{
water_vp_sat(temperature, over.ice = FALSE, method = "tetens")

water_dp(water.vp, over.ice = FALSE, method = "tetens")

water_vp2mvc(water.vp, temperature)

water_mvc2vp(water.mvc, temperature)
}
\arguments{
\item{temperature}{numeric vector of air temperatures (C).}

\item{over.ice}{logical Is the estimate for equilibrium with liquid water or with ice.}

\item{method}{character Currently "tetens" and modified "magnus" equations
are supported.}

\item{water.vp}{numeric vector of water vapour pressure in air (Pa).}

\item{water.mvc}{numeric vector of water vapour concnetration as mass per volume (g m-3).}
}
\value{
A numeric vector of partial pressures in pascal (P) for
  \code{water_vp_sat} and \code{water_mvc2vp}, a numeric vector of dew point
  temperatures (C) for \code{water_dp} and numeric vector of mass per
  volume concentrations (g m-3) for \code{water_vp2mvc}.
}
\description{
Approximate water pressure in air as a function of temperature, and its inverse
the calculation of dewpoint.
}
\details{
This is an implementation of Tetens (1930) equation for the cases of
  equilibrium with a water and an ice surface and of the modified Magnus
  equations of Alduchov and Eskridge (1996, eqs. 21 and 23).

  The equations are approximations, and in spite of the different names, have
  the same form with the only difference in the values of the parameters.
  However, the modified Magnus equation is more accurate as Tetens equation
  suffers from some bias errors at extreme low temperatures (< -40 C). In
  contrast Magnus equations with recently fitted values for the parameters
  are usable for temperatures from -80 C to +50 C over water and -80 C to 0 C
  over ice. The switch between equations for ice or water cannot be based on
  air temperature, as it depends on the presence or not of a surface of
  liquid water.
}
\note{
Tetens equation is still very frequently used, and is for example the
  one recommended by FAO for computing potential evapotranspiration. For
  this reason it is used as default here.
}
\examples{
water_vp_sat(20) # C -> Pa
water_vp_sat(-10) # over water!!
water_vp_sat(-10, over.ice = TRUE)
water_vp_sat(20) / 100 # C -> mbar

water_dp(1000) # Pa -> C

water_vp2mvc(1000, 20) # Pa -> g m-3

water_mvc2vp(30, 40) # g m-3 -> Pa

water_dp(water_mvc2vp(10, 30)) # g m-3 -> C

}
\references{
Tetens, O., 1930. Uber einige meteorologische Begriffe. Zeitschrift fur
 Geophysik, Vol. 6:297.

 Alduchov, O. A., Eskridge, R. E., 1996. Improved Magnus Form Approximation of
 Saturation Vapor Pressure. Journal of Applied Meteorology, 35: 601-609 .

 Monteith, J., Unsworth, M. (2008) Principles of Environmental Physics.
 Academic Press, Amsterdam.

 [Equations describing the physical properties of moist air](http://www.conservationphysics.org/atmcalc/atmoclc2.pdf)
}
