% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.length2rgb.r
\name{w_length2rgb}
\alias{w_length2rgb}
\title{Wavelength to rgb color conversion}
\usage{
w_length2rgb(w.length, sens = photobiology::ciexyzCMF2.spct,
  color.name = NULL)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{sens}{chroma_spct Used as chromaticity definition}

\item{color.name}{character Used for naming the rgb color definition}
}
\value{
A vector of colors defined using \code{rgb()}. The numeric values of
  the RGB components can be obtained using function \code{col2rgb()}.
}
\description{
Calculates rgb values from spectra based on human color matching functions
}
\examples{
col2rgb(w_length2rgb(580))
col2rgb(w_length2rgb(c(400, 500, 600, 700)))
col2rgb(w_length2rgb(c(400, 500, 600, 700), color.name=c("a","b","c","d")))
col2rgb(w_length2rgb(c(400, 500, 600, 700), color.name="a"))

}
\seealso{
Other color functions: \code{\link{rgb_spct}},
  \code{\link{w_length_range2rgb}}
}
\concept{color functions}
