% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.row.funs.r
\name{rowwise}
\alias{rowwise}
\alias{rowwise_filter}
\alias{rowwise_source}
\alias{rowwise_response}
\alias{rowwise_reflector}
\alias{rowwise_calibration}
\title{rowwise functions for collections of spectra}
\usage{
rowwise_filter(x, .fun, col.name.tag = "", .fun.name = "Summary of",
  ...)

rowwise_source(x, .fun, col.name.tag = "", .fun.name = "Summary of",
  ...)

rowwise_response(x, .fun, col.name.tag = "", .fun.name = "Summary of",
  ...)

rowwise_reflector(x, .fun, col.name.tag = "", .fun.name = "Summary of",
  ...)

rowwise_calibration(x, .fun, col.name.tag = "",
  .fun.name = "Summary of", ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections of
spectral objects.}

\item{.fun}{An R function or a list of functions.}

\item{col.name.tag}{character Vector of extensions to paste to default column
name for the output from each of the functions. If col.name.tag[1] != "",
this forces the return of an object of class \code{"generic_spct"}.}

\item{.fun.name}{character string used to set what.measured attribute.}

\item{...}{Arguments passed to .fun.}
}
\description{
Private methods for collections of spectra. Applies a function at each wavelength
across all the spectra in the collection.
}
\note{
Omission of NAs is done separately at each wavelength. Interpolation is
  not applied, so all spectra in \code{x} must share the same set of
  wavelengths. When defining new public functions using these utility
  functions make sure to return data that is valid for the class of spectral
  returned!!
}
\seealso{
\code{\link[base]{mean}}
}
\keyword{internal}
