% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.summaries.r, R/waveband.class.r
\name{is_effective.summary_generic_spct}
\alias{is_effective}
\alias{is_effective.default}
\alias{is_effective.generic_spct}
\alias{is_effective.source_spct}
\alias{is_effective.summary_generic_spct}
\alias{is_effective.summary_source_spct}
\alias{is_effective.waveband}
\title{Is an R object "effective"}
\usage{
\method{is_effective}{summary_generic_spct}(x)

\method{is_effective}{summary_source_spct}(x)

is_effective(x)

\method{is_effective}{default}(x)

\method{is_effective}{waveband}(x)

\method{is_effective}{generic_spct}(x)

\method{is_effective}{source_spct}(x)
}
\arguments{
\item{x}{an R object}
}
\value{
A \code{logical}.
}
\description{
A generic function for quering if a biological spectral weighting function
(BSWF) has been applied to an object or is included in its definition.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary_generic_spct}: Does a \code{summary_generic_spct} object contain
a summary of effective spectral irradiance values.

\item \code{summary_source_spct}: Does a \code{summary_source_spct} object contain
a summary of effective spectral irradiance values.

\item \code{default}: Default method.

\item \code{waveband}: Is a \code{waveband} object defining a method for
calcualtaing effective irradiance.

\item \code{generic_spct}: Does a \code{source_spct} object contain effective
spectral irradiance values.

\item \code{source_spct}: Does a \code{source_spct} object contain effective
spectral irradiance values.
}}
\examples{
is_effective(summary(sun.spct))

}
\seealso{
Other waveband attributes: \code{\link{labels.waveband}},
  \code{\link{normalization}}
}

